package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PurchaseReservedCacheNodesOfferingResponse(
    reservedCacheNode: Optional[zio.aws.elasticache.model.ReservedCacheNode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse = {
    import PurchaseReservedCacheNodesOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse
      .builder()
      .optionallyWith(reservedCacheNode.map(value => value.buildAwsValue()))(
        _.reservedCacheNode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.ReadOnly =
    zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse
      .wrap(buildAwsValue())
}
object PurchaseReservedCacheNodesOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse =
      zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse(
        reservedCacheNode.map(value => value.asEditable)
      )
    def reservedCacheNode
        : Optional[zio.aws.elasticache.model.ReservedCacheNode.ReadOnly]
    def getReservedCacheNode: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReservedCacheNode.ReadOnly
    ] = AwsError.unwrapOptionField("reservedCacheNode", reservedCacheNode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse
  ) extends zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.ReadOnly {
    override val reservedCacheNode
        : Optional[zio.aws.elasticache.model.ReservedCacheNode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedCacheNode())
        .map(value => zio.aws.elasticache.model.ReservedCacheNode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse
  ): zio.aws.elasticache.model.PurchaseReservedCacheNodesOfferingResponse.ReadOnly =
    new Wrapper(impl)
}
