package zio.aws.elasticache.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.TStamp
import scala.jdk.CollectionConverters.*
final case class NodeGroupMemberUpdateStatus(
    cacheClusterId: Optional[String] = Optional.Absent,
    cacheNodeId: Optional[String] = Optional.Absent,
    nodeUpdateStatus: Optional[zio.aws.elasticache.model.NodeUpdateStatus] =
      Optional.Absent,
    nodeDeletionDate: Optional[TStamp] = Optional.Absent,
    nodeUpdateStartDate: Optional[TStamp] = Optional.Absent,
    nodeUpdateEndDate: Optional[TStamp] = Optional.Absent,
    nodeUpdateInitiatedBy: Optional[
      zio.aws.elasticache.model.NodeUpdateInitiatedBy
    ] = Optional.Absent,
    nodeUpdateInitiatedDate: Optional[TStamp] = Optional.Absent,
    nodeUpdateStatusModifiedDate: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus = {
    import NodeGroupMemberUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(cacheNodeId.map(value => value: java.lang.String))(
        _.cacheNodeId
      )
      .optionallyWith(nodeUpdateStatus.map(value => value.unwrap))(
        _.nodeUpdateStatus
      )
      .optionallyWith(
        nodeDeletionDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeDeletionDate)
      .optionallyWith(
        nodeUpdateStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeUpdateStartDate)
      .optionallyWith(
        nodeUpdateEndDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeUpdateEndDate)
      .optionallyWith(nodeUpdateInitiatedBy.map(value => value.unwrap))(
        _.nodeUpdateInitiatedBy
      )
      .optionallyWith(
        nodeUpdateInitiatedDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeUpdateInitiatedDate)
      .optionallyWith(
        nodeUpdateStatusModifiedDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeUpdateStatusModifiedDate)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly =
    zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.wrap(buildAwsValue())
}
object NodeGroupMemberUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeGroupMemberUpdateStatus =
      zio.aws.elasticache.model.NodeGroupMemberUpdateStatus(
        cacheClusterId.map(value => value),
        cacheNodeId.map(value => value),
        nodeUpdateStatus.map(value => value),
        nodeDeletionDate.map(value => value),
        nodeUpdateStartDate.map(value => value),
        nodeUpdateEndDate.map(value => value),
        nodeUpdateInitiatedBy.map(value => value),
        nodeUpdateInitiatedDate.map(value => value),
        nodeUpdateStatusModifiedDate.map(value => value)
      )
    def cacheClusterId: Optional[String]
    def cacheNodeId: Optional[String]
    def nodeUpdateStatus: Optional[zio.aws.elasticache.model.NodeUpdateStatus]
    def nodeDeletionDate: Optional[TStamp]
    def nodeUpdateStartDate: Optional[TStamp]
    def nodeUpdateEndDate: Optional[TStamp]
    def nodeUpdateInitiatedBy
        : Optional[zio.aws.elasticache.model.NodeUpdateInitiatedBy]
    def nodeUpdateInitiatedDate: Optional[TStamp]
    def nodeUpdateStatusModifiedDate: Optional[TStamp]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeId", cacheNodeId)
    def getNodeUpdateStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.NodeUpdateStatus] =
      AwsError.unwrapOptionField("nodeUpdateStatus", nodeUpdateStatus)
    def getNodeDeletionDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("nodeDeletionDate", nodeDeletionDate)
    def getNodeUpdateStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("nodeUpdateStartDate", nodeUpdateStartDate)
    def getNodeUpdateEndDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("nodeUpdateEndDate", nodeUpdateEndDate)
    def getNodeUpdateInitiatedBy
        : ZIO[Any, AwsError, zio.aws.elasticache.model.NodeUpdateInitiatedBy] =
      AwsError.unwrapOptionField("nodeUpdateInitiatedBy", nodeUpdateInitiatedBy)
    def getNodeUpdateInitiatedDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("nodeUpdateInitiatedDate", nodeUpdateInitiatedDate)
    def getNodeUpdateStatusModifiedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "nodeUpdateStatusModifiedDate",
        nodeUpdateStatusModifiedDate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus
  ) extends zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly {
    override val cacheClusterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheClusterId())
      .map(value => value: String)
    override val cacheNodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeId())
      .map(value => value: String)
    override val nodeUpdateStatus
        : Optional[zio.aws.elasticache.model.NodeUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeUpdateStatus())
        .map(value => zio.aws.elasticache.model.NodeUpdateStatus.wrap(value))
    override val nodeDeletionDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeDeletionDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val nodeUpdateStartDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeUpdateStartDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val nodeUpdateEndDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeUpdateEndDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val nodeUpdateInitiatedBy
        : Optional[zio.aws.elasticache.model.NodeUpdateInitiatedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeUpdateInitiatedBy())
        .map(value =>
          zio.aws.elasticache.model.NodeUpdateInitiatedBy.wrap(value)
        )
    override val nodeUpdateInitiatedDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeUpdateInitiatedDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val nodeUpdateStatusModifiedDate: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeUpdateStatusModifiedDate())
        .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus
  ): zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly =
    new Wrapper(impl)
}
