package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CacheNodeTypeSpecificParameter(
    parameterName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    source: Optional[String] = Optional.Absent,
    dataType: Optional[String] = Optional.Absent,
    allowedValues: Optional[String] = Optional.Absent,
    isModifiable: Optional[Boolean] = Optional.Absent,
    minimumEngineVersion: Optional[String] = Optional.Absent,
    cacheNodeTypeSpecificValues: Optional[
      Iterable[zio.aws.elasticache.model.CacheNodeTypeSpecificValue]
    ] = Optional.Absent,
    changeType: Optional[zio.aws.elasticache.model.ChangeType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter = {
    import CacheNodeTypeSpecificParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter
      .builder()
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(
        cacheNodeTypeSpecificValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheNodeTypeSpecificValues)
      .optionallyWith(changeType.map(value => value.unwrap))(_.changeType)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly =
    zio.aws.elasticache.model.CacheNodeTypeSpecificParameter
      .wrap(buildAwsValue())
}
object CacheNodeTypeSpecificParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheNodeTypeSpecificParameter =
      zio.aws.elasticache.model.CacheNodeTypeSpecificParameter(
        parameterName.map(value => value),
        description.map(value => value),
        source.map(value => value),
        dataType.map(value => value),
        allowedValues.map(value => value),
        isModifiable.map(value => value),
        minimumEngineVersion.map(value => value),
        cacheNodeTypeSpecificValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        changeType.map(value => value)
      )
    def parameterName: Optional[String]
    def description: Optional[String]
    def source: Optional[String]
    def dataType: Optional[String]
    def allowedValues: Optional[String]
    def isModifiable: Optional[Boolean]
    def minimumEngineVersion: Optional[String]
    def cacheNodeTypeSpecificValues: Optional[
      List[zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly]
    ]
    def changeType: Optional[zio.aws.elasticache.model.ChangeType]
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getCacheNodeTypeSpecificValues: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cacheNodeTypeSpecificValues",
      cacheNodeTypeSpecificValues
    )
    def getChangeType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ChangeType] =
      AwsError.unwrapOptionField("changeType", changeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter
  ) extends zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly {
    override val parameterName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parameterName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val dataType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataType())
      .map(value => value: String)
    override val allowedValues: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value => value: String)
    override val isModifiable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isModifiable())
      .map(value => value: Boolean)
    override val minimumEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumEngineVersion())
      .map(value => value: String)
    override val cacheNodeTypeSpecificValues: Optional[
      List[zio.aws.elasticache.model.CacheNodeTypeSpecificValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheNodeTypeSpecificValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheNodeTypeSpecificValue.wrap(item)
        }.toList
      )
    override val changeType: Optional[zio.aws.elasticache.model.ChangeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeType())
        .map(value => zio.aws.elasticache.model.ChangeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificParameter
  ): zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly =
    new Wrapper(impl)
}
