package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{UserId, EngineType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UserGroup(
    userGroupId: Option[String] = None,
    status: Option[String] = None,
    engine: Option[EngineType] = None,
    userIds: Option[Iterable[UserId]] = None,
    minimumEngineVersion: Option[String] = None,
    pendingChanges: Option[zio.aws.elasticache.model.UserGroupPendingChanges] =
      None,
    replicationGroups: Option[Iterable[String]] = None,
    arn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.UserGroup = {
    import UserGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.UserGroup
      .builder()
      .optionallyWith(userGroupId.map(value => value: java.lang.String))(
        _.userGroupId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        engine.map(value => EngineType.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            UserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        minimumEngineVersion.map(value => value: java.lang.String)
      )(_.minimumEngineVersion)
      .optionallyWith(pendingChanges.map(value => value.buildAwsValue()))(
        _.pendingChanges
      )
      .optionallyWith(
        replicationGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationGroups)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.UserGroup.ReadOnly =
    zio.aws.elasticache.model.UserGroup.wrap(buildAwsValue())
}
object UserGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.UserGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.UserGroup =
      zio.aws.elasticache.model.UserGroup(
        userGroupId.map(value => value),
        status.map(value => value),
        engine.map(value => value),
        userIds.map(value => value),
        minimumEngineVersion.map(value => value),
        pendingChanges.map(value => value.asEditable),
        replicationGroups.map(value => value),
        arn.map(value => value)
      )
    def userGroupId: Option[String]
    def status: Option[String]
    def engine: Option[EngineType]
    def userIds: Option[List[UserId]]
    def minimumEngineVersion: Option[String]
    def pendingChanges
        : Option[zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly]
    def replicationGroups: Option[List[String]]
    def arn: Option[String]
    def getUserGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userGroupId", userGroupId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEngine: ZIO[Any, AwsError, EngineType] =
      AwsError.unwrapOptionField("engine", engine)
    def getUserIds: ZIO[Any, AwsError, List[UserId]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getMinimumEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersion)
    def getPendingChanges: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly
    ] = AwsError.unwrapOptionField("pendingChanges", pendingChanges)
    def getReplicationGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicationGroups", replicationGroups)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.UserGroup
  ) extends zio.aws.elasticache.model.UserGroup.ReadOnly {
    override val userGroupId: Option[String] =
      scala.Option(impl.userGroupId()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val engine: Option[EngineType] = scala
      .Option(impl.engine())
      .map(value => zio.aws.elasticache.model.primitives.EngineType(value))
    override val userIds: Option[List[UserId]] = scala
      .Option(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserId(item)
        }.toList
      )
    override val minimumEngineVersion: Option[String] =
      scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    override val pendingChanges
        : Option[zio.aws.elasticache.model.UserGroupPendingChanges.ReadOnly] =
      scala
        .Option(impl.pendingChanges())
        .map(value =>
          zio.aws.elasticache.model.UserGroupPendingChanges.wrap(value)
        )
    override val replicationGroups: Option[List[String]] = scala
      .Option(impl.replicationGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.UserGroup
  ): zio.aws.elasticache.model.UserGroup.ReadOnly = new Wrapper(impl)
}
