package zio.aws.elasticache.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{
  UserGroupId,
  TStamp,
  BooleanOptional,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ReplicationGroup(
    replicationGroupId: Option[String] = None,
    description: Option[String] = None,
    globalReplicationGroupInfo: Option[
      zio.aws.elasticache.model.GlobalReplicationGroupInfo
    ] = None,
    status: Option[String] = None,
    pendingModifiedValues: Option[
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues
    ] = None,
    memberClusters: Option[Iterable[String]] = None,
    nodeGroups: Option[Iterable[zio.aws.elasticache.model.NodeGroup]] = None,
    snapshottingClusterId: Option[String] = None,
    automaticFailover: Option[
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = None,
    multiAZ: Option[zio.aws.elasticache.model.MultiAZStatus] = None,
    configurationEndpoint: Option[zio.aws.elasticache.model.Endpoint] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    clusterEnabled: Option[BooleanOptional] = None,
    cacheNodeType: Option[String] = None,
    authTokenEnabled: Option[BooleanOptional] = None,
    authTokenLastModifiedDate: Option[TStamp] = None,
    transitEncryptionEnabled: Option[BooleanOptional] = None,
    atRestEncryptionEnabled: Option[BooleanOptional] = None,
    memberClustersOutpostArns: Option[Iterable[String]] = None,
    kmsKeyId: Option[String] = None,
    arn: Option[String] = None,
    userGroupIds: Option[Iterable[UserGroupId]] = None,
    logDeliveryConfigurations: Option[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfiguration]
    ] = None,
    replicationGroupCreateTime: Option[TStamp] = None,
    dataTiering: Option[zio.aws.elasticache.model.DataTieringStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ReplicationGroup = {
    import ReplicationGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ReplicationGroup
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        globalReplicationGroupInfo.map(value => value.buildAwsValue())
      )(_.globalReplicationGroupInfo)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        memberClusters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.memberClusters)
      .optionallyWith(
        nodeGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeGroups)
      .optionallyWith(
        snapshottingClusterId.map(value => value: java.lang.String)
      )(_.snapshottingClusterId)
      .optionallyWith(automaticFailover.map(value => value.unwrap))(
        _.automaticFailover
      )
      .optionallyWith(multiAZ.map(value => value.unwrap))(_.multiAZ)
      .optionallyWith(
        configurationEndpoint.map(value => value.buildAwsValue())
      )(_.configurationEndpoint)
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(clusterEnabled.map(value => value: java.lang.Boolean))(
        _.clusterEnabled
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(authTokenEnabled.map(value => value: java.lang.Boolean))(
        _.authTokenEnabled
      )
      .optionallyWith(
        authTokenLastModifiedDate.map(value => TStamp.unwrap(value): Instant)
      )(_.authTokenLastModifiedDate)
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(
        memberClustersOutpostArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.memberClustersOutpostArns)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        userGroupIds.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIds)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .optionallyWith(
        replicationGroupCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.replicationGroupCreateTime)
      .optionallyWith(dataTiering.map(value => value.unwrap))(_.dataTiering)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ReplicationGroup.ReadOnly =
    zio.aws.elasticache.model.ReplicationGroup.wrap(buildAwsValue())
}
object ReplicationGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ReplicationGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ReplicationGroup =
      zio.aws.elasticache.model.ReplicationGroup(
        replicationGroupId.map(value => value),
        description.map(value => value),
        globalReplicationGroupInfo.map(value => value.asEditable),
        status.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        memberClusters.map(value => value),
        nodeGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        snapshottingClusterId.map(value => value),
        automaticFailover.map(value => value),
        multiAZ.map(value => value),
        configurationEndpoint.map(value => value.asEditable),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        clusterEnabled.map(value => value),
        cacheNodeType.map(value => value),
        authTokenEnabled.map(value => value),
        authTokenLastModifiedDate.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        memberClustersOutpostArns.map(value => value),
        kmsKeyId.map(value => value),
        arn.map(value => value),
        userGroupIds.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicationGroupCreateTime.map(value => value),
        dataTiering.map(value => value)
      )
    def replicationGroupId: Option[String]
    def description: Option[String]
    def globalReplicationGroupInfo
        : Option[zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly]
    def status: Option[String]
    def pendingModifiedValues: Option[
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly
    ]
    def memberClusters: Option[List[String]]
    def nodeGroups: Option[List[zio.aws.elasticache.model.NodeGroup.ReadOnly]]
    def snapshottingClusterId: Option[String]
    def automaticFailover
        : Option[zio.aws.elasticache.model.AutomaticFailoverStatus]
    def multiAZ: Option[zio.aws.elasticache.model.MultiAZStatus]
    def configurationEndpoint
        : Option[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def snapshotWindow: Option[String]
    def clusterEnabled: Option[BooleanOptional]
    def cacheNodeType: Option[String]
    def authTokenEnabled: Option[BooleanOptional]
    def authTokenLastModifiedDate: Option[TStamp]
    def transitEncryptionEnabled: Option[BooleanOptional]
    def atRestEncryptionEnabled: Option[BooleanOptional]
    def memberClustersOutpostArns: Option[List[String]]
    def kmsKeyId: Option[String]
    def arn: Option[String]
    def userGroupIds: Option[List[UserGroupId]]
    def logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly]
    ]
    def replicationGroupCreateTime: Option[TStamp]
    def dataTiering: Option[zio.aws.elasticache.model.DataTieringStatus]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGlobalReplicationGroupInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalReplicationGroupInfo",
      globalReplicationGroupInfo
    )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getMemberClusters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("memberClusters", memberClusters)
    def getNodeGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.NodeGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("nodeGroups", nodeGroups)
    def getSnapshottingClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshottingClusterId", snapshottingClusterId)
    def getAutomaticFailover: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = AwsError.unwrapOptionField("automaticFailover", automaticFailover)
    def getMultiAZ
        : ZIO[Any, AwsError, zio.aws.elasticache.model.MultiAZStatus] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getConfigurationEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("configurationEndpoint", configurationEndpoint)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getClusterEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("clusterEnabled", clusterEnabled)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getAuthTokenEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("authTokenEnabled", authTokenEnabled)
    def getAuthTokenLastModifiedDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("authTokenLastModifiedDate", authTokenLastModifiedDate)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "atRestEncryptionEnabled",
        atRestEncryptionEnabled
      )
    def getMemberClustersOutpostArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "memberClustersOutpostArns",
        memberClustersOutpostArns
      )
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getUserGroupIds: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIds", userGroupIds)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
    def getReplicationGroupCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "replicationGroupCreateTime",
        replicationGroupCreateTime
      )
    def getDataTiering
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DataTieringStatus] =
      AwsError.unwrapOptionField("dataTiering", dataTiering)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ReplicationGroup
  ) extends zio.aws.elasticache.model.ReplicationGroup.ReadOnly {
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val globalReplicationGroupInfo: Option[
      zio.aws.elasticache.model.GlobalReplicationGroupInfo.ReadOnly
    ] = scala
      .Option(impl.globalReplicationGroupInfo())
      .map(value =>
        zio.aws.elasticache.model.GlobalReplicationGroupInfo.wrap(value)
      )
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val pendingModifiedValues: Option[
      zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues.ReadOnly
    ] = scala
      .Option(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.elasticache.model.ReplicationGroupPendingModifiedValues
          .wrap(value)
      )
    override val memberClusters: Option[List[String]] = scala
      .Option(impl.memberClusters())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nodeGroups
        : Option[List[zio.aws.elasticache.model.NodeGroup.ReadOnly]] = scala
      .Option(impl.nodeGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.NodeGroup.wrap(item)
        }.toList
      )
    override val snapshottingClusterId: Option[String] =
      scala.Option(impl.snapshottingClusterId()).map(value => value: String)
    override val automaticFailover
        : Option[zio.aws.elasticache.model.AutomaticFailoverStatus] = scala
      .Option(impl.automaticFailover())
      .map(value =>
        zio.aws.elasticache.model.AutomaticFailoverStatus.wrap(value)
      )
    override val multiAZ: Option[zio.aws.elasticache.model.MultiAZStatus] =
      scala
        .Option(impl.multiAZ())
        .map(value => zio.aws.elasticache.model.MultiAZStatus.wrap(value))
    override val configurationEndpoint
        : Option[zio.aws.elasticache.model.Endpoint.ReadOnly] = scala
      .Option(impl.configurationEndpoint())
      .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => value: IntegerOptional)
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val clusterEnabled: Option[BooleanOptional] =
      scala.Option(impl.clusterEnabled()).map(value => value: BooleanOptional)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val authTokenEnabled: Option[BooleanOptional] =
      scala.Option(impl.authTokenEnabled()).map(value => value: BooleanOptional)
    override val authTokenLastModifiedDate: Option[TStamp] = scala
      .Option(impl.authTokenLastModifiedDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val transitEncryptionEnabled: Option[BooleanOptional] = scala
      .Option(impl.transitEncryptionEnabled())
      .map(value => value: BooleanOptional)
    override val atRestEncryptionEnabled: Option[BooleanOptional] = scala
      .Option(impl.atRestEncryptionEnabled())
      .map(value => value: BooleanOptional)
    override val memberClustersOutpostArns: Option[List[String]] = scala
      .Option(impl.memberClustersOutpostArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val userGroupIds: Option[List[UserGroupId]] = scala
      .Option(impl.userGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserGroupId(item)
        }.toList
      )
    override val logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly]
    ] = scala
      .Option(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val replicationGroupCreateTime: Option[TStamp] = scala
      .Option(impl.replicationGroupCreateTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val dataTiering
        : Option[zio.aws.elasticache.model.DataTieringStatus] = scala
      .Option(impl.dataTiering())
      .map(value => zio.aws.elasticache.model.DataTieringStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ReplicationGroup
  ): zio.aws.elasticache.model.ReplicationGroup.ReadOnly = new Wrapper(impl)
}
