package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RemoveTagsFromResourceResponse(
    tagList: Option[Iterable[zio.aws.elasticache.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse = {
    import RemoveTagsFromResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse
      .builder()
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.RemoveTagsFromResourceResponse.ReadOnly =
    zio.aws.elasticache.model.RemoveTagsFromResourceResponse
      .wrap(buildAwsValue())
}
object RemoveTagsFromResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.RemoveTagsFromResourceResponse =
      zio.aws.elasticache.model.RemoveTagsFromResourceResponse(
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagList: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]]
    def getTagList
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse
  ) extends zio.aws.elasticache.model.RemoveTagsFromResourceResponse.ReadOnly {
    override val tagList: Option[List[zio.aws.elasticache.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.RemoveTagsFromResourceResponse
  ): zio.aws.elasticache.model.RemoveTagsFromResourceResponse.ReadOnly =
    new Wrapper(impl)
}
