package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class NodeGroupMemberUpdateStatus(
    cacheClusterId: Option[String] = None,
    cacheNodeId: Option[String] = None,
    nodeUpdateStatus: Option[zio.aws.elasticache.model.NodeUpdateStatus] = None,
    nodeDeletionDate: Option[TStamp] = None,
    nodeUpdateStartDate: Option[TStamp] = None,
    nodeUpdateEndDate: Option[TStamp] = None,
    nodeUpdateInitiatedBy: Option[
      zio.aws.elasticache.model.NodeUpdateInitiatedBy
    ] = None,
    nodeUpdateInitiatedDate: Option[TStamp] = None,
    nodeUpdateStatusModifiedDate: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus = {
    import NodeGroupMemberUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(cacheNodeId.map(value => value: java.lang.String))(
        _.cacheNodeId
      )
      .optionallyWith(nodeUpdateStatus.map(value => value.unwrap))(
        _.nodeUpdateStatus
      )
      .optionallyWith(
        nodeDeletionDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeDeletionDate)
      .optionallyWith(
        nodeUpdateStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeUpdateStartDate)
      .optionallyWith(
        nodeUpdateEndDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeUpdateEndDate)
      .optionallyWith(nodeUpdateInitiatedBy.map(value => value.unwrap))(
        _.nodeUpdateInitiatedBy
      )
      .optionallyWith(
        nodeUpdateInitiatedDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeUpdateInitiatedDate)
      .optionallyWith(
        nodeUpdateStatusModifiedDate.map(value => TStamp.unwrap(value): Instant)
      )(_.nodeUpdateStatusModifiedDate)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly =
    zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.wrap(buildAwsValue())
}
object NodeGroupMemberUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.NodeGroupMemberUpdateStatus =
      zio.aws.elasticache.model.NodeGroupMemberUpdateStatus(
        cacheClusterId.map(value => value),
        cacheNodeId.map(value => value),
        nodeUpdateStatus.map(value => value),
        nodeDeletionDate.map(value => value),
        nodeUpdateStartDate.map(value => value),
        nodeUpdateEndDate.map(value => value),
        nodeUpdateInitiatedBy.map(value => value),
        nodeUpdateInitiatedDate.map(value => value),
        nodeUpdateStatusModifiedDate.map(value => value)
      )
    def cacheClusterId: Option[String]
    def cacheNodeId: Option[String]
    def nodeUpdateStatus: Option[zio.aws.elasticache.model.NodeUpdateStatus]
    def nodeDeletionDate: Option[TStamp]
    def nodeUpdateStartDate: Option[TStamp]
    def nodeUpdateEndDate: Option[TStamp]
    def nodeUpdateInitiatedBy
        : Option[zio.aws.elasticache.model.NodeUpdateInitiatedBy]
    def nodeUpdateInitiatedDate: Option[TStamp]
    def nodeUpdateStatusModifiedDate: Option[TStamp]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getCacheNodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeId", cacheNodeId)
    def getNodeUpdateStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.NodeUpdateStatus] =
      AwsError.unwrapOptionField("nodeUpdateStatus", nodeUpdateStatus)
    def getNodeDeletionDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("nodeDeletionDate", nodeDeletionDate)
    def getNodeUpdateStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("nodeUpdateStartDate", nodeUpdateStartDate)
    def getNodeUpdateEndDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("nodeUpdateEndDate", nodeUpdateEndDate)
    def getNodeUpdateInitiatedBy
        : ZIO[Any, AwsError, zio.aws.elasticache.model.NodeUpdateInitiatedBy] =
      AwsError.unwrapOptionField("nodeUpdateInitiatedBy", nodeUpdateInitiatedBy)
    def getNodeUpdateInitiatedDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("nodeUpdateInitiatedDate", nodeUpdateInitiatedDate)
    def getNodeUpdateStatusModifiedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "nodeUpdateStatusModifiedDate",
        nodeUpdateStatusModifiedDate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus
  ) extends zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly {
    override val cacheClusterId: Option[String] =
      scala.Option(impl.cacheClusterId()).map(value => value: String)
    override val cacheNodeId: Option[String] =
      scala.Option(impl.cacheNodeId()).map(value => value: String)
    override val nodeUpdateStatus
        : Option[zio.aws.elasticache.model.NodeUpdateStatus] = scala
      .Option(impl.nodeUpdateStatus())
      .map(value => zio.aws.elasticache.model.NodeUpdateStatus.wrap(value))
    override val nodeDeletionDate: Option[TStamp] = scala
      .Option(impl.nodeDeletionDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val nodeUpdateStartDate: Option[TStamp] = scala
      .Option(impl.nodeUpdateStartDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val nodeUpdateEndDate: Option[TStamp] = scala
      .Option(impl.nodeUpdateEndDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val nodeUpdateInitiatedBy
        : Option[zio.aws.elasticache.model.NodeUpdateInitiatedBy] = scala
      .Option(impl.nodeUpdateInitiatedBy())
      .map(value => zio.aws.elasticache.model.NodeUpdateInitiatedBy.wrap(value))
    override val nodeUpdateInitiatedDate: Option[TStamp] = scala
      .Option(impl.nodeUpdateInitiatedDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val nodeUpdateStatusModifiedDate: Option[TStamp] = scala
      .Option(impl.nodeUpdateStatusModifiedDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.NodeGroupMemberUpdateStatus
  ): zio.aws.elasticache.model.NodeGroupMemberUpdateStatus.ReadOnly =
    new Wrapper(impl)
}
