package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyReplicationGroupShardConfigurationResponse(
    replicationGroup: Option[zio.aws.elasticache.model.ReplicationGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse = {
    import ModifyReplicationGroupShardConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse
      .builder()
      .optionallyWith(replicationGroup.map(value => value.buildAwsValue()))(
        _.replicationGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.ReadOnly =
    zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse
      .wrap(buildAwsValue())
}
object ModifyReplicationGroupShardConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse =
      zio.aws.elasticache.model
        .ModifyReplicationGroupShardConfigurationResponse(
          replicationGroup.map(value => value.asEditable)
        )
    def replicationGroup
        : Option[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]
    def getReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField("replicationGroup", replicationGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse
  ) extends zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.ReadOnly {
    override val replicationGroup
        : Option[zio.aws.elasticache.model.ReplicationGroup.ReadOnly] = scala
      .Option(impl.replicationGroup())
      .map(value => zio.aws.elasticache.model.ReplicationGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationResponse
  ): zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
