package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyCacheClusterResponse(
    cacheCluster: Option[zio.aws.elasticache.model.CacheCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse = {
    import ModifyCacheClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse
      .builder()
      .optionallyWith(cacheCluster.map(value => value.buildAwsValue()))(
        _.cacheCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyCacheClusterResponse.ReadOnly =
    zio.aws.elasticache.model.ModifyCacheClusterResponse.wrap(buildAwsValue())
}
object ModifyCacheClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyCacheClusterResponse =
      zio.aws.elasticache.model
        .ModifyCacheClusterResponse(cacheCluster.map(value => value.asEditable))
    def cacheCluster: Option[zio.aws.elasticache.model.CacheCluster.ReadOnly]
    def getCacheCluster
        : ZIO[Any, AwsError, zio.aws.elasticache.model.CacheCluster.ReadOnly] =
      AwsError.unwrapOptionField("cacheCluster", cacheCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse
  ) extends zio.aws.elasticache.model.ModifyCacheClusterResponse.ReadOnly {
    override val cacheCluster
        : Option[zio.aws.elasticache.model.CacheCluster.ReadOnly] = scala
      .Option(impl.cacheCluster())
      .map(value => zio.aws.elasticache.model.CacheCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyCacheClusterResponse
  ): zio.aws.elasticache.model.ModifyCacheClusterResponse.ReadOnly =
    new Wrapper(impl)
}
