package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LogDeliveryConfigurationRequest(
    logType: Option[zio.aws.elasticache.model.LogType] = None,
    destinationType: Option[zio.aws.elasticache.model.DestinationType] = None,
    destinationDetails: Option[zio.aws.elasticache.model.DestinationDetails] =
      None,
    logFormat: Option[zio.aws.elasticache.model.LogFormat] = None,
    enabled: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest = {
    import LogDeliveryConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest
      .builder()
      .optionallyWith(logType.map(value => value.unwrap))(_.logType)
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(destinationDetails.map(value => value.buildAwsValue()))(
        _.destinationDetails
      )
      .optionallyWith(logFormat.map(value => value.unwrap))(_.logFormat)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly =
    zio.aws.elasticache.model.LogDeliveryConfigurationRequest
      .wrap(buildAwsValue())
}
object LogDeliveryConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.LogDeliveryConfigurationRequest =
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest(
        logType.map(value => value),
        destinationType.map(value => value),
        destinationDetails.map(value => value.asEditable),
        logFormat.map(value => value),
        enabled.map(value => value)
      )
    def logType: Option[zio.aws.elasticache.model.LogType]
    def destinationType: Option[zio.aws.elasticache.model.DestinationType]
    def destinationDetails
        : Option[zio.aws.elasticache.model.DestinationDetails.ReadOnly]
    def logFormat: Option[zio.aws.elasticache.model.LogFormat]
    def enabled: Option[BooleanOptional]
    def getLogType: ZIO[Any, AwsError, zio.aws.elasticache.model.LogType] =
      AwsError.unwrapOptionField("logType", logType)
    def getDestinationType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.DestinationType] =
      AwsError.unwrapOptionField("destinationType", destinationType)
    def getDestinationDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.DestinationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("destinationDetails", destinationDetails)
    def getLogFormat: ZIO[Any, AwsError, zio.aws.elasticache.model.LogFormat] =
      AwsError.unwrapOptionField("logFormat", logFormat)
    def getEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest
  ) extends zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly {
    override val logType: Option[zio.aws.elasticache.model.LogType] = scala
      .Option(impl.logType())
      .map(value => zio.aws.elasticache.model.LogType.wrap(value))
    override val destinationType
        : Option[zio.aws.elasticache.model.DestinationType] = scala
      .Option(impl.destinationType())
      .map(value => zio.aws.elasticache.model.DestinationType.wrap(value))
    override val destinationDetails
        : Option[zio.aws.elasticache.model.DestinationDetails.ReadOnly] = scala
      .Option(impl.destinationDetails())
      .map(value => zio.aws.elasticache.model.DestinationDetails.wrap(value))
    override val logFormat: Option[zio.aws.elasticache.model.LogFormat] = scala
      .Option(impl.logFormat())
      .map(value => zio.aws.elasticache.model.LogFormat.wrap(value))
    override val enabled: Option[BooleanOptional] =
      scala.Option(impl.enabled()).map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest
  ): zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
