package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DestinationDetails(
    cloudWatchLogsDetails: Option[
      zio.aws.elasticache.model.CloudWatchLogsDestinationDetails
    ] = None,
    kinesisFirehoseDetails: Option[
      zio.aws.elasticache.model.KinesisFirehoseDestinationDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DestinationDetails = {
    import DestinationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DestinationDetails
      .builder()
      .optionallyWith(
        cloudWatchLogsDetails.map(value => value.buildAwsValue())
      )(_.cloudWatchLogsDetails)
      .optionallyWith(
        kinesisFirehoseDetails.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseDetails)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DestinationDetails.ReadOnly =
    zio.aws.elasticache.model.DestinationDetails.wrap(buildAwsValue())
}
object DestinationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DestinationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DestinationDetails =
      zio.aws.elasticache.model.DestinationDetails(
        cloudWatchLogsDetails.map(value => value.asEditable),
        kinesisFirehoseDetails.map(value => value.asEditable)
      )
    def cloudWatchLogsDetails: Option[
      zio.aws.elasticache.model.CloudWatchLogsDestinationDetails.ReadOnly
    ]
    def kinesisFirehoseDetails: Option[
      zio.aws.elasticache.model.KinesisFirehoseDestinationDetails.ReadOnly
    ]
    def getCloudWatchLogsDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CloudWatchLogsDestinationDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("cloudWatchLogsDetails", cloudWatchLogsDetails)
    def getKinesisFirehoseDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.KinesisFirehoseDestinationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseDetails",
      kinesisFirehoseDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DestinationDetails
  ) extends zio.aws.elasticache.model.DestinationDetails.ReadOnly {
    override val cloudWatchLogsDetails: Option[
      zio.aws.elasticache.model.CloudWatchLogsDestinationDetails.ReadOnly
    ] = scala
      .Option(impl.cloudWatchLogsDetails())
      .map(value =>
        zio.aws.elasticache.model.CloudWatchLogsDestinationDetails.wrap(value)
      )
    override val kinesisFirehoseDetails: Option[
      zio.aws.elasticache.model.KinesisFirehoseDestinationDetails.ReadOnly
    ] = scala
      .Option(impl.kinesisFirehoseDetails())
      .map(value =>
        zio.aws.elasticache.model.KinesisFirehoseDestinationDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DestinationDetails
  ): zio.aws.elasticache.model.DestinationDetails.ReadOnly = new Wrapper(impl)
}
