package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{
  IntegerOptional,
  UserId,
  EngineType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeUsersRequest(
    engine: Option[EngineType] = None,
    userId: Option[UserId] = None,
    filters: Option[Iterable[zio.aws.elasticache.model.Filter]] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest = {
    import DescribeUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest
      .builder()
      .optionallyWith(
        engine.map(value => EngineType.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DescribeUsersRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeUsersRequest.wrap(buildAwsValue())
}
object DescribeUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUsersRequest =
      zio.aws.elasticache.model.DescribeUsersRequest(
        engine.map(value => value),
        userId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def engine: Option[EngineType]
    def userId: Option[UserId]
    def filters: Option[List[zio.aws.elasticache.model.Filter.ReadOnly]]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getEngine: ZIO[Any, AwsError, EngineType] =
      AwsError.unwrapOptionField("engine", engine)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.elasticache.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest
  ) extends zio.aws.elasticache.model.DescribeUsersRequest.ReadOnly {
    override val engine: Option[EngineType] = scala
      .Option(impl.engine())
      .map(value => zio.aws.elasticache.model.primitives.EngineType(value))
    override val userId: Option[UserId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.elasticache.model.primitives.UserId(value))
    override val filters
        : Option[List[zio.aws.elasticache.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.Filter.wrap(item)
        }.toList
      )
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUsersRequest
  ): zio.aws.elasticache.model.DescribeUsersRequest.ReadOnly = new Wrapper(impl)
}
