package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeUpdateActionsResponse(
    marker: Option[String] = None,
    updateActions: Option[Iterable[zio.aws.elasticache.model.UpdateAction]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse = {
    import DescribeUpdateActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        updateActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updateActions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeUpdateActionsResponse
      .wrap(buildAwsValue())
}
object DescribeUpdateActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUpdateActionsResponse =
      zio.aws.elasticache.model.DescribeUpdateActionsResponse(
        marker.map(value => value),
        updateActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def updateActions
        : Option[List[zio.aws.elasticache.model.UpdateAction.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getUpdateActions: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.UpdateAction.ReadOnly
    ]] = AwsError.unwrapOptionField("updateActions", updateActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse
  ) extends zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val updateActions
        : Option[List[zio.aws.elasticache.model.UpdateAction.ReadOnly]] = scala
      .Option(impl.updateActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.UpdateAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse
  ): zio.aws.elasticache.model.DescribeUpdateActionsResponse.ReadOnly =
    new Wrapper(impl)
}
