package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotsResponse(
    marker: Option[String] = None,
    snapshots: Option[Iterable[zio.aws.elasticache.model.Snapshot]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse = {
    import DescribeSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DescribeSnapshotsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeSnapshotsResponse =
      zio.aws.elasticache.model.DescribeSnapshotsResponse(
        marker.map(value => value),
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def snapshots: Option[List[zio.aws.elasticache.model.Snapshot.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getSnapshots: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.Snapshot.ReadOnly
    ]] = AwsError.unwrapOptionField("snapshots", snapshots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse
  ) extends zio.aws.elasticache.model.DescribeSnapshotsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val snapshots
        : Option[List[zio.aws.elasticache.model.Snapshot.ReadOnly]] = scala
      .Option(impl.snapshots())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.Snapshot.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsResponse
  ): zio.aws.elasticache.model.DescribeSnapshotsResponse.ReadOnly = new Wrapper(
    impl
  )
}
