package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSnapshotsRequest(
    replicationGroupId: Option[String] = None,
    cacheClusterId: Option[String] = None,
    snapshotName: Option[String] = None,
    snapshotSource: Option[String] = None,
    marker: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    showNodeGroupConfig: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest = {
    import DescribeSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(snapshotName.map(value => value: java.lang.String))(
        _.snapshotName
      )
      .optionallyWith(snapshotSource.map(value => value: java.lang.String))(
        _.snapshotSource
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(
        showNodeGroupConfig.map(value => value: java.lang.Boolean)
      )(_.showNodeGroupConfig)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DescribeSnapshotsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeSnapshotsRequest =
      zio.aws.elasticache.model.DescribeSnapshotsRequest(
        replicationGroupId.map(value => value),
        cacheClusterId.map(value => value),
        snapshotName.map(value => value),
        snapshotSource.map(value => value),
        marker.map(value => value),
        maxRecords.map(value => value),
        showNodeGroupConfig.map(value => value)
      )
    def replicationGroupId: Option[String]
    def cacheClusterId: Option[String]
    def snapshotName: Option[String]
    def snapshotSource: Option[String]
    def marker: Option[String]
    def maxRecords: Option[IntegerOptional]
    def showNodeGroupConfig: Option[BooleanOptional]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getSnapshotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
    def getSnapshotSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotSource", snapshotSource)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getShowNodeGroupConfig: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showNodeGroupConfig", showNodeGroupConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest
  ) extends zio.aws.elasticache.model.DescribeSnapshotsRequest.ReadOnly {
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
    override val cacheClusterId: Option[String] =
      scala.Option(impl.cacheClusterId()).map(value => value: String)
    override val snapshotName: Option[String] =
      scala.Option(impl.snapshotName()).map(value => value: String)
    override val snapshotSource: Option[String] =
      scala.Option(impl.snapshotSource()).map(value => value: String)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val showNodeGroupConfig: Option[BooleanOptional] = scala
      .Option(impl.showNodeGroupConfig())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeSnapshotsRequest
  ): zio.aws.elasticache.model.DescribeSnapshotsRequest.ReadOnly = new Wrapper(
    impl
  )
}
