package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeServiceUpdatesResponse(
    marker: Option[String] = None,
    serviceUpdates: Option[Iterable[zio.aws.elasticache.model.ServiceUpdate]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse = {
    import DescribeServiceUpdatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        serviceUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceUpdates)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeServiceUpdatesResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeServiceUpdatesResponse
      .wrap(buildAwsValue())
}
object DescribeServiceUpdatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeServiceUpdatesResponse =
      zio.aws.elasticache.model.DescribeServiceUpdatesResponse(
        marker.map(value => value),
        serviceUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def serviceUpdates
        : Option[List[zio.aws.elasticache.model.ServiceUpdate.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getServiceUpdates: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ServiceUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceUpdates", serviceUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse
  ) extends zio.aws.elasticache.model.DescribeServiceUpdatesResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val serviceUpdates
        : Option[List[zio.aws.elasticache.model.ServiceUpdate.ReadOnly]] = scala
      .Option(impl.serviceUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ServiceUpdate.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse
  ): zio.aws.elasticache.model.DescribeServiceUpdatesResponse.ReadOnly =
    new Wrapper(impl)
}
