package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeReplicationGroupsResponse(
    marker: Option[String] = None,
    replicationGroups: Option[
      Iterable[zio.aws.elasticache.model.ReplicationGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse = {
    import DescribeReplicationGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeReplicationGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeReplicationGroupsResponse =
      zio.aws.elasticache.model.DescribeReplicationGroupsResponse(
        marker.map(value => value),
        replicationGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def replicationGroups
        : Option[List[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ReplicationGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationGroups", replicationGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse
  ) extends zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val replicationGroups
        : Option[List[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]] =
      scala
        .Option(impl.replicationGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ReplicationGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse
  ): zio.aws.elasticache.model.DescribeReplicationGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
