package zio.aws.elasticache.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{IntegerOptional, TStamp}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEventsRequest(
    sourceIdentifier: Option[String] = None,
    sourceType: Option[zio.aws.elasticache.model.SourceType] = None,
    startTime: Option[TStamp] = None,
    endTime: Option[TStamp] = None,
    duration: Option[IntegerOptional] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest = {
    import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest
      .builder()
      .optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(
        _.sourceIdentifier
      )
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(startTime.map(value => TStamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => TStamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(duration.map(value => value: Integer))(_.duration)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DescribeEventsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeEventsRequest.wrap(buildAwsValue())
}
object DescribeEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeEventsRequest =
      zio.aws.elasticache.model.DescribeEventsRequest(
        sourceIdentifier.map(value => value),
        sourceType.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        duration.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def sourceIdentifier: Option[String]
    def sourceType: Option[zio.aws.elasticache.model.SourceType]
    def startTime: Option[TStamp]
    def endTime: Option[TStamp]
    def duration: Option[IntegerOptional]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getSourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDuration: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("duration", duration)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest
  ) extends zio.aws.elasticache.model.DescribeEventsRequest.ReadOnly {
    override val sourceIdentifier: Option[String] =
      scala.Option(impl.sourceIdentifier()).map(value => value: String)
    override val sourceType: Option[zio.aws.elasticache.model.SourceType] =
      scala
        .Option(impl.sourceType())
        .map(value => zio.aws.elasticache.model.SourceType.wrap(value))
    override val startTime: Option[TStamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val endTime: Option[TStamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val duration: Option[IntegerOptional] =
      scala.Option(impl.duration()).map(value => value: IntegerOptional)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeEventsRequest
  ): zio.aws.elasticache.model.DescribeEventsRequest.ReadOnly = new Wrapper(
    impl
  )
}
