package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCacheParametersRequest(
    cacheParameterGroupName: String,
    source: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest = {
    import DescribeCacheParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest
      .builder()
      .cacheParameterGroupName(cacheParameterGroupName: java.lang.String)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheParametersRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheParametersRequest
      .wrap(buildAwsValue())
}
object DescribeCacheParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeCacheParametersRequest =
      zio.aws.elasticache.model.DescribeCacheParametersRequest(
        cacheParameterGroupName,
        source.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def cacheParameterGroupName: String
    def source: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getCacheParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(cacheParameterGroupName)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest
  ) extends zio.aws.elasticache.model.DescribeCacheParametersRequest.ReadOnly {
    override val cacheParameterGroupName: String =
      impl.cacheParameterGroupName(): String
    override val source: Option[String] =
      scala.Option(impl.source()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] =
      scala.Option(impl.maxRecords()).map(value => value: IntegerOptional)
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest
  ): zio.aws.elasticache.model.DescribeCacheParametersRequest.ReadOnly =
    new Wrapper(impl)
}
