package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCacheClustersResponse(
    marker: Option[String] = None,
    cacheClusters: Option[Iterable[zio.aws.elasticache.model.CacheCluster]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse = {
    import DescribeCacheClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        cacheClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheClusters)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheClustersResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheClustersResponse
      .wrap(buildAwsValue())
}
object DescribeCacheClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeCacheClustersResponse =
      zio.aws.elasticache.model.DescribeCacheClustersResponse(
        marker.map(value => value),
        cacheClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def cacheClusters
        : Option[List[zio.aws.elasticache.model.CacheCluster.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCacheClusters: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheCluster.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheClusters", cacheClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse
  ) extends zio.aws.elasticache.model.DescribeCacheClustersResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val cacheClusters
        : Option[List[zio.aws.elasticache.model.CacheCluster.ReadOnly]] = scala
      .Option(impl.cacheClusters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheCluster.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersResponse
  ): zio.aws.elasticache.model.DescribeCacheClustersResponse.ReadOnly =
    new Wrapper(impl)
}
