package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCacheClusterResponse(
    cacheCluster: Option[zio.aws.elasticache.model.CacheCluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse = {
    import CreateCacheClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse
      .builder()
      .optionallyWith(cacheCluster.map(value => value.buildAwsValue()))(
        _.cacheCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateCacheClusterResponse.ReadOnly =
    zio.aws.elasticache.model.CreateCacheClusterResponse.wrap(buildAwsValue())
}
object CreateCacheClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateCacheClusterResponse =
      zio.aws.elasticache.model
        .CreateCacheClusterResponse(cacheCluster.map(value => value.asEditable))
    def cacheCluster: Option[zio.aws.elasticache.model.CacheCluster.ReadOnly]
    def getCacheCluster
        : ZIO[Any, AwsError, zio.aws.elasticache.model.CacheCluster.ReadOnly] =
      AwsError.unwrapOptionField("cacheCluster", cacheCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse
  ) extends zio.aws.elasticache.model.CreateCacheClusterResponse.ReadOnly {
    override val cacheCluster
        : Option[zio.aws.elasticache.model.CacheCluster.ReadOnly] = scala
      .Option(impl.cacheCluster())
      .map(value => zio.aws.elasticache.model.CacheCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheClusterResponse
  ): zio.aws.elasticache.model.CreateCacheClusterResponse.ReadOnly =
    new Wrapper(impl)
}
