package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{Integer, AllowedNodeGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConfigureShard(
    nodeGroupId: AllowedNodeGroupId,
    newReplicaCount: Integer,
    preferredAvailabilityZones: Option[Iterable[String]] = None,
    preferredOutpostArns: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ConfigureShard = {
    import ConfigureShard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ConfigureShard
      .builder()
      .nodeGroupId(AllowedNodeGroupId.unwrap(nodeGroupId): java.lang.String)
      .newReplicaCount(newReplicaCount: java.lang.Integer)
      .optionallyWith(
        preferredAvailabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredAvailabilityZones)
      .optionallyWith(
        preferredOutpostArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.preferredOutpostArns)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ConfigureShard.ReadOnly =
    zio.aws.elasticache.model.ConfigureShard.wrap(buildAwsValue())
}
object ConfigureShard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ConfigureShard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ConfigureShard =
      zio.aws.elasticache.model.ConfigureShard(
        nodeGroupId,
        newReplicaCount,
        preferredAvailabilityZones.map(value => value),
        preferredOutpostArns.map(value => value)
      )
    def nodeGroupId: AllowedNodeGroupId
    def newReplicaCount: Integer
    def preferredAvailabilityZones: Option[List[String]]
    def preferredOutpostArns: Option[List[String]]
    def getNodeGroupId: ZIO[Any, Nothing, AllowedNodeGroupId] =
      ZIO.succeed(nodeGroupId)
    def getNewReplicaCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(newReplicaCount)
    def getPreferredAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "preferredAvailabilityZones",
        preferredAvailabilityZones
      )
    def getPreferredOutpostArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("preferredOutpostArns", preferredOutpostArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ConfigureShard
  ) extends zio.aws.elasticache.model.ConfigureShard.ReadOnly {
    override val nodeGroupId: AllowedNodeGroupId =
      zio.aws.elasticache.model.primitives
        .AllowedNodeGroupId(impl.nodeGroupId())
    override val newReplicaCount: Integer = impl.newReplicaCount(): Integer
    override val preferredAvailabilityZones: Option[List[String]] = scala
      .Option(impl.preferredAvailabilityZones())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val preferredOutpostArns: Option[List[String]] = scala
      .Option(impl.preferredOutpostArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ConfigureShard
  ): zio.aws.elasticache.model.ConfigureShard.ReadOnly = new Wrapper(impl)
}
