package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CompleteMigrationRequest(
    replicationGroupId: String,
    force: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest = {
    import CompleteMigrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CompleteMigrationRequest.ReadOnly =
    zio.aws.elasticache.model.CompleteMigrationRequest.wrap(buildAwsValue())
}
object CompleteMigrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CompleteMigrationRequest =
      zio.aws.elasticache.model
        .CompleteMigrationRequest(replicationGroupId, force.map(value => value))
    def replicationGroupId: String
    def force: Option[Boolean]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest
  ) extends zio.aws.elasticache.model.CompleteMigrationRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val force: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CompleteMigrationRequest
  ): zio.aws.elasticache.model.CompleteMigrationRequest.ReadOnly = new Wrapper(
    impl
  )
}
