package zio.aws.elasticache.model
import scala.jdk.CollectionConverters.*
sealed trait ChangeType {
  def unwrap: software.amazon.awssdk.services.elasticache.model.ChangeType
}
object ChangeType {
  def wrap(
      value: software.amazon.awssdk.services.elasticache.model.ChangeType
  ): zio.aws.elasticache.model.ChangeType = value match {
    case software.amazon.awssdk.services.elasticache.model.ChangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticache.model.ChangeType.IMMEDIATE =>
      val r = immediate
      r
    case software.amazon.awssdk.services.elasticache.model.ChangeType.REQUIRES_REBOOT =>
      val r = `requires-reboot`
      r
  }
  case object unknownToSdkVersion extends zio.aws.elasticache.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ChangeType =
      software.amazon.awssdk.services.elasticache.model.ChangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object immediate extends zio.aws.elasticache.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ChangeType =
      software.amazon.awssdk.services.elasticache.model.ChangeType.IMMEDIATE
  }
  case object `requires-reboot` extends zio.aws.elasticache.model.ChangeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticache.model.ChangeType =
      software.amazon.awssdk.services.elasticache.model.ChangeType.REQUIRES_REBOOT
  }
}
