package zio.aws.elasticache.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticache.model.primitives.{
  BooleanOptional,
  TStamp,
  IntegerOptional
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CacheCluster(
    cacheClusterId: Option[String] = None,
    configurationEndpoint: Option[zio.aws.elasticache.model.Endpoint] = None,
    clientDownloadLandingPage: Option[String] = None,
    cacheNodeType: Option[String] = None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    cacheClusterStatus: Option[String] = None,
    numCacheNodes: Option[IntegerOptional] = None,
    preferredAvailabilityZone: Option[String] = None,
    preferredOutpostArn: Option[String] = None,
    cacheClusterCreateTime: Option[TStamp] = None,
    preferredMaintenanceWindow: Option[String] = None,
    pendingModifiedValues: Option[
      zio.aws.elasticache.model.PendingModifiedValues
    ] = None,
    notificationConfiguration: Option[
      zio.aws.elasticache.model.NotificationConfiguration
    ] = None,
    cacheSecurityGroups: Option[
      Iterable[zio.aws.elasticache.model.CacheSecurityGroupMembership]
    ] = None,
    cacheParameterGroup: Option[
      zio.aws.elasticache.model.CacheParameterGroupStatus
    ] = None,
    cacheSubnetGroupName: Option[String] = None,
    cacheNodes: Option[Iterable[zio.aws.elasticache.model.CacheNode]] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    securityGroups: Option[
      Iterable[zio.aws.elasticache.model.SecurityGroupMembership]
    ] = None,
    replicationGroupId: Option[String] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    authTokenEnabled: Option[BooleanOptional] = None,
    authTokenLastModifiedDate: Option[TStamp] = None,
    transitEncryptionEnabled: Option[BooleanOptional] = None,
    atRestEncryptionEnabled: Option[BooleanOptional] = None,
    arn: Option[String] = None,
    replicationGroupLogDeliveryEnabled: Option[Boolean] = None,
    logDeliveryConfigurations: Option[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CacheCluster = {
    import CacheCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CacheCluster
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(
        configurationEndpoint.map(value => value.buildAwsValue())
      )(_.configurationEndpoint)
      .optionallyWith(
        clientDownloadLandingPage.map(value => value: java.lang.String)
      )(_.clientDownloadLandingPage)
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(cacheClusterStatus.map(value => value: java.lang.String))(
        _.cacheClusterStatus
      )
      .optionallyWith(numCacheNodes.map(value => value: Integer))(
        _.numCacheNodes
      )
      .optionallyWith(
        preferredAvailabilityZone.map(value => value: java.lang.String)
      )(_.preferredAvailabilityZone)
      .optionallyWith(
        preferredOutpostArn.map(value => value: java.lang.String)
      )(_.preferredOutpostArn)
      .optionallyWith(
        cacheClusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.cacheClusterCreateTime)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        notificationConfiguration.map(value => value.buildAwsValue())
      )(_.notificationConfiguration)
      .optionallyWith(
        cacheSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheSecurityGroups)
      .optionallyWith(cacheParameterGroup.map(value => value.buildAwsValue()))(
        _.cacheParameterGroup
      )
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(
        cacheNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheNodes)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(snapshotRetentionLimit.map(value => value: Integer))(
        _.snapshotRetentionLimit
      )
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(authTokenEnabled.map(value => value: java.lang.Boolean))(
        _.authTokenEnabled
      )
      .optionallyWith(
        authTokenLastModifiedDate.map(value => TStamp.unwrap(value): Instant)
      )(_.authTokenLastModifiedDate)
      .optionallyWith(
        transitEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.transitEncryptionEnabled)
      .optionallyWith(
        atRestEncryptionEnabled.map(value => value: java.lang.Boolean)
      )(_.atRestEncryptionEnabled)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        replicationGroupLogDeliveryEnabled.map(value =>
          value: java.lang.Boolean
        )
      )(_.replicationGroupLogDeliveryEnabled)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CacheCluster.ReadOnly =
    zio.aws.elasticache.model.CacheCluster.wrap(buildAwsValue())
}
object CacheCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CacheCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CacheCluster =
      zio.aws.elasticache.model.CacheCluster(
        cacheClusterId.map(value => value),
        configurationEndpoint.map(value => value.asEditable),
        clientDownloadLandingPage.map(value => value),
        cacheNodeType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        cacheClusterStatus.map(value => value),
        numCacheNodes.map(value => value),
        preferredAvailabilityZone.map(value => value),
        preferredOutpostArn.map(value => value),
        cacheClusterCreateTime.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        notificationConfiguration.map(value => value.asEditable),
        cacheSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheParameterGroup.map(value => value.asEditable),
        cacheSubnetGroupName.map(value => value),
        cacheNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoMinorVersionUpgrade.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicationGroupId.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        authTokenEnabled.map(value => value),
        authTokenLastModifiedDate.map(value => value),
        transitEncryptionEnabled.map(value => value),
        atRestEncryptionEnabled.map(value => value),
        arn.map(value => value),
        replicationGroupLogDeliveryEnabled.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cacheClusterId: Option[String]
    def configurationEndpoint
        : Option[zio.aws.elasticache.model.Endpoint.ReadOnly]
    def clientDownloadLandingPage: Option[String]
    def cacheNodeType: Option[String]
    def engine: Option[String]
    def engineVersion: Option[String]
    def cacheClusterStatus: Option[String]
    def numCacheNodes: Option[IntegerOptional]
    def preferredAvailabilityZone: Option[String]
    def preferredOutpostArn: Option[String]
    def cacheClusterCreateTime: Option[TStamp]
    def preferredMaintenanceWindow: Option[String]
    def pendingModifiedValues
        : Option[zio.aws.elasticache.model.PendingModifiedValues.ReadOnly]
    def notificationConfiguration
        : Option[zio.aws.elasticache.model.NotificationConfiguration.ReadOnly]
    def cacheSecurityGroups: Option[
      List[zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly]
    ]
    def cacheParameterGroup
        : Option[zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly]
    def cacheSubnetGroupName: Option[String]
    def cacheNodes: Option[List[zio.aws.elasticache.model.CacheNode.ReadOnly]]
    def autoMinorVersionUpgrade: Option[Boolean]
    def securityGroups: Option[
      List[zio.aws.elasticache.model.SecurityGroupMembership.ReadOnly]
    ]
    def replicationGroupId: Option[String]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def snapshotWindow: Option[String]
    def authTokenEnabled: Option[BooleanOptional]
    def authTokenLastModifiedDate: Option[TStamp]
    def transitEncryptionEnabled: Option[BooleanOptional]
    def atRestEncryptionEnabled: Option[BooleanOptional]
    def arn: Option[String]
    def replicationGroupLogDeliveryEnabled: Option[Boolean]
    def logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly]
    ]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getConfigurationEndpoint
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("configurationEndpoint", configurationEndpoint)
    def getClientDownloadLandingPage: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clientDownloadLandingPage", clientDownloadLandingPage)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getCacheClusterStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterStatus", cacheClusterStatus)
    def getNumCacheNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numCacheNodes", numCacheNodes)
    def getPreferredAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("preferredAvailabilityZone", preferredAvailabilityZone)
    def getPreferredOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredOutpostArn", preferredOutpostArn)
    def getCacheClusterCreateTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("cacheClusterCreateTime", cacheClusterCreateTime)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.PendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.NotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationConfiguration",
      notificationConfiguration
    )
    def getCacheSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheSecurityGroups", cacheSecurityGroups)
    def getCacheParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly
    ] = AwsError.unwrapOptionField("cacheParameterGroup", cacheParameterGroup)
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getCacheNodes: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheNode.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheNodes", cacheNodes)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.SecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getAuthTokenEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("authTokenEnabled", authTokenEnabled)
    def getAuthTokenLastModifiedDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("authTokenLastModifiedDate", authTokenLastModifiedDate)
    def getTransitEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "transitEncryptionEnabled",
        transitEncryptionEnabled
      )
    def getAtRestEncryptionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "atRestEncryptionEnabled",
        atRestEncryptionEnabled
      )
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getReplicationGroupLogDeliveryEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "replicationGroupLogDeliveryEnabled",
        replicationGroupLogDeliveryEnabled
      )
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CacheCluster
  ) extends zio.aws.elasticache.model.CacheCluster.ReadOnly {
    override val cacheClusterId: Option[String] =
      scala.Option(impl.cacheClusterId()).map(value => value: String)
    override val configurationEndpoint
        : Option[zio.aws.elasticache.model.Endpoint.ReadOnly] = scala
      .Option(impl.configurationEndpoint())
      .map(value => zio.aws.elasticache.model.Endpoint.wrap(value))
    override val clientDownloadLandingPage: Option[String] =
      scala.Option(impl.clientDownloadLandingPage()).map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val cacheClusterStatus: Option[String] =
      scala.Option(impl.cacheClusterStatus()).map(value => value: String)
    override val numCacheNodes: Option[IntegerOptional] =
      scala.Option(impl.numCacheNodes()).map(value => value: IntegerOptional)
    override val preferredAvailabilityZone: Option[String] =
      scala.Option(impl.preferredAvailabilityZone()).map(value => value: String)
    override val preferredOutpostArn: Option[String] =
      scala.Option(impl.preferredOutpostArn()).map(value => value: String)
    override val cacheClusterCreateTime: Option[TStamp] = scala
      .Option(impl.cacheClusterCreateTime())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val pendingModifiedValues
        : Option[zio.aws.elasticache.model.PendingModifiedValues.ReadOnly] =
      scala
        .Option(impl.pendingModifiedValues())
        .map(value =>
          zio.aws.elasticache.model.PendingModifiedValues.wrap(value)
        )
    override val notificationConfiguration
        : Option[zio.aws.elasticache.model.NotificationConfiguration.ReadOnly] =
      scala
        .Option(impl.notificationConfiguration())
        .map(value =>
          zio.aws.elasticache.model.NotificationConfiguration.wrap(value)
        )
    override val cacheSecurityGroups: Option[
      List[zio.aws.elasticache.model.CacheSecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.cacheSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val cacheParameterGroup
        : Option[zio.aws.elasticache.model.CacheParameterGroupStatus.ReadOnly] =
      scala
        .Option(impl.cacheParameterGroup())
        .map(value =>
          zio.aws.elasticache.model.CacheParameterGroupStatus.wrap(value)
        )
    override val cacheSubnetGroupName: Option[String] =
      scala.Option(impl.cacheSubnetGroupName()).map(value => value: String)
    override val cacheNodes
        : Option[List[zio.aws.elasticache.model.CacheNode.ReadOnly]] = scala
      .Option(impl.cacheNodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheNode.wrap(item)
        }.toList
      )
    override val autoMinorVersionUpgrade: Option[Boolean] =
      scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
    override val securityGroups: Option[
      List[zio.aws.elasticache.model.SecurityGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.SecurityGroupMembership.wrap(item)
        }.toList
      )
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => value: IntegerOptional)
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val authTokenEnabled: Option[BooleanOptional] =
      scala.Option(impl.authTokenEnabled()).map(value => value: BooleanOptional)
    override val authTokenLastModifiedDate: Option[TStamp] = scala
      .Option(impl.authTokenLastModifiedDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val transitEncryptionEnabled: Option[BooleanOptional] = scala
      .Option(impl.transitEncryptionEnabled())
      .map(value => value: BooleanOptional)
    override val atRestEncryptionEnabled: Option[BooleanOptional] = scala
      .Option(impl.atRestEncryptionEnabled())
      .map(value => value: BooleanOptional)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val replicationGroupLogDeliveryEnabled: Option[Boolean] = scala
      .Option(impl.replicationGroupLogDeliveryEnabled())
      .map(value => value: Boolean)
    override val logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfiguration.ReadOnly]
    ] = scala
      .Option(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CacheCluster
  ): zio.aws.elasticache.model.CacheCluster.ReadOnly = new Wrapper(impl)
}
