package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchStopUpdateActionRequest(
    replicationGroupIds: Option[Iterable[String]] = None,
    cacheClusterIds: Option[Iterable[String]] = None,
    serviceUpdateName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest = {
    import BatchStopUpdateActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest
      .builder()
      .optionallyWith(
        replicationGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationGroupIds)
      .optionallyWith(
        cacheClusterIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheClusterIds)
      .serviceUpdateName(serviceUpdateName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.BatchStopUpdateActionRequest.ReadOnly =
    zio.aws.elasticache.model.BatchStopUpdateActionRequest.wrap(buildAwsValue())
}
object BatchStopUpdateActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.BatchStopUpdateActionRequest =
      zio.aws.elasticache.model.BatchStopUpdateActionRequest(
        replicationGroupIds.map(value => value),
        cacheClusterIds.map(value => value),
        serviceUpdateName
      )
    def replicationGroupIds: Option[List[String]]
    def cacheClusterIds: Option[List[String]]
    def serviceUpdateName: String
    def getReplicationGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicationGroupIds", replicationGroupIds)
    def getCacheClusterIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cacheClusterIds", cacheClusterIds)
    def getServiceUpdateName: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceUpdateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest
  ) extends zio.aws.elasticache.model.BatchStopUpdateActionRequest.ReadOnly {
    override val replicationGroupIds: Option[List[String]] = scala
      .Option(impl.replicationGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cacheClusterIds: Option[List[String]] = scala
      .Option(impl.cacheClusterIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val serviceUpdateName: String = impl.serviceUpdateName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.BatchStopUpdateActionRequest
  ): zio.aws.elasticache.model.BatchStopUpdateActionRequest.ReadOnly =
    new Wrapper(impl)
}
