package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.UserGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UserGroupsUpdateStatus(
    userGroupIdsToAdd: Option[Iterable[UserGroupId]] = None,
    userGroupIdsToRemove: Option[Iterable[UserGroupId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.UserGroupsUpdateStatus = {
    import UserGroupsUpdateStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.UserGroupsUpdateStatus
      .builder()
      .optionallyWith(
        userGroupIdsToAdd.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIdsToAdd)
      .optionallyWith(
        userGroupIdsToRemove.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIdsToRemove)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.UserGroupsUpdateStatus.ReadOnly =
    zio.aws.elasticache.model.UserGroupsUpdateStatus.wrap(buildAwsValue())
}
object UserGroupsUpdateStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.UserGroupsUpdateStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.UserGroupsUpdateStatus =
      zio.aws.elasticache.model.UserGroupsUpdateStatus(
        userGroupIdsToAdd.map(value => value),
        userGroupIdsToRemove.map(value => value)
      )
    def userGroupIdsToAdd: Option[List[UserGroupId]]
    def userGroupIdsToRemove: Option[List[UserGroupId]]
    def getUserGroupIdsToAdd: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIdsToAdd", userGroupIdsToAdd)
    def getUserGroupIdsToRemove: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIdsToRemove", userGroupIdsToRemove)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.UserGroupsUpdateStatus
  ) extends zio.aws.elasticache.model.UserGroupsUpdateStatus.ReadOnly {
    override val userGroupIdsToAdd: Option[List[UserGroupId]] = scala
      .Option(impl.userGroupIdsToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserGroupId(item)
        }.toList
      )
    override val userGroupIdsToRemove: Option[List[UserGroupId]] = scala
      .Option(impl.userGroupIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserGroupId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.UserGroupsUpdateStatus
  ): zio.aws.elasticache.model.UserGroupsUpdateStatus.ReadOnly = new Wrapper(
    impl
  )
}
