package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Subnet(
    subnetIdentifier: Option[String] = None,
    subnetAvailabilityZone: Option[zio.aws.elasticache.model.AvailabilityZone] =
      None,
    subnetOutpost: Option[zio.aws.elasticache.model.SubnetOutpost] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.Subnet
      .builder()
      .optionallyWith(subnetIdentifier.map(value => value: java.lang.String))(
        _.subnetIdentifier
      )
      .optionallyWith(
        subnetAvailabilityZone.map(value => value.buildAwsValue())
      )(_.subnetAvailabilityZone)
      .optionallyWith(subnetOutpost.map(value => value.buildAwsValue()))(
        _.subnetOutpost
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.Subnet.ReadOnly =
    zio.aws.elasticache.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.Subnet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.Subnet =
      zio.aws.elasticache.model.Subnet(
        subnetIdentifier.map(value => value),
        subnetAvailabilityZone.map(value => value.asEditable),
        subnetOutpost.map(value => value.asEditable)
      )
    def subnetIdentifier: Option[String]
    def subnetAvailabilityZone
        : Option[zio.aws.elasticache.model.AvailabilityZone.ReadOnly]
    def subnetOutpost: Option[zio.aws.elasticache.model.SubnetOutpost.ReadOnly]
    def getSubnetIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifier)
    def getSubnetAvailabilityZone: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AvailabilityZone.ReadOnly
    ] = AwsError.unwrapOptionField(
      "subnetAvailabilityZone",
      subnetAvailabilityZone
    )
    def getSubnetOutpost
        : ZIO[Any, AwsError, zio.aws.elasticache.model.SubnetOutpost.ReadOnly] =
      AwsError.unwrapOptionField("subnetOutpost", subnetOutpost)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.Subnet
  ) extends zio.aws.elasticache.model.Subnet.ReadOnly {
    override val subnetIdentifier: Option[String] =
      scala.Option(impl.subnetIdentifier()).map(value => value: String)
    override val subnetAvailabilityZone
        : Option[zio.aws.elasticache.model.AvailabilityZone.ReadOnly] = scala
      .Option(impl.subnetAvailabilityZone())
      .map(value => zio.aws.elasticache.model.AvailabilityZone.wrap(value))
    override val subnetOutpost
        : Option[zio.aws.elasticache.model.SubnetOutpost.ReadOnly] = scala
      .Option(impl.subnetOutpost())
      .map(value => zio.aws.elasticache.model.SubnetOutpost.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.Subnet
  ): zio.aws.elasticache.model.Subnet.ReadOnly = new Wrapper(impl)
}
