package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{BooleanOptional, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ServiceUpdate(
    serviceUpdateName: Option[String] = None,
    serviceUpdateReleaseDate: Option[TStamp] = None,
    serviceUpdateEndDate: Option[TStamp] = None,
    serviceUpdateSeverity: Option[
      zio.aws.elasticache.model.ServiceUpdateSeverity
    ] = None,
    serviceUpdateRecommendedApplyByDate: Option[TStamp] = None,
    serviceUpdateStatus: Option[zio.aws.elasticache.model.ServiceUpdateStatus] =
      None,
    serviceUpdateDescription: Option[String] = None,
    serviceUpdateType: Option[zio.aws.elasticache.model.ServiceUpdateType] =
      None,
    engine: Option[String] = None,
    engineVersion: Option[String] = None,
    autoUpdateAfterRecommendedApplyByDate: Option[BooleanOptional] = None,
    estimatedUpdateTime: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ServiceUpdate = {
    import ServiceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ServiceUpdate
      .builder()
      .optionallyWith(serviceUpdateName.map(value => value: java.lang.String))(
        _.serviceUpdateName
      )
      .optionallyWith(
        serviceUpdateReleaseDate.map(value => TStamp.unwrap(value): Instant)
      )(_.serviceUpdateReleaseDate)
      .optionallyWith(
        serviceUpdateEndDate.map(value => TStamp.unwrap(value): Instant)
      )(_.serviceUpdateEndDate)
      .optionallyWith(serviceUpdateSeverity.map(value => value.unwrap))(
        _.serviceUpdateSeverity
      )
      .optionallyWith(
        serviceUpdateRecommendedApplyByDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.serviceUpdateRecommendedApplyByDate)
      .optionallyWith(serviceUpdateStatus.map(value => value.unwrap))(
        _.serviceUpdateStatus
      )
      .optionallyWith(
        serviceUpdateDescription.map(value => value: java.lang.String)
      )(_.serviceUpdateDescription)
      .optionallyWith(serviceUpdateType.map(value => value.unwrap))(
        _.serviceUpdateType
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoUpdateAfterRecommendedApplyByDate.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoUpdateAfterRecommendedApplyByDate)
      .optionallyWith(
        estimatedUpdateTime.map(value => value: java.lang.String)
      )(_.estimatedUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.ServiceUpdate.ReadOnly =
    zio.aws.elasticache.model.ServiceUpdate.wrap(buildAwsValue())
}
object ServiceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ServiceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ServiceUpdate =
      zio.aws.elasticache.model.ServiceUpdate(
        serviceUpdateName.map(value => value),
        serviceUpdateReleaseDate.map(value => value),
        serviceUpdateEndDate.map(value => value),
        serviceUpdateSeverity.map(value => value),
        serviceUpdateRecommendedApplyByDate.map(value => value),
        serviceUpdateStatus.map(value => value),
        serviceUpdateDescription.map(value => value),
        serviceUpdateType.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        autoUpdateAfterRecommendedApplyByDate.map(value => value),
        estimatedUpdateTime.map(value => value)
      )
    def serviceUpdateName: Option[String]
    def serviceUpdateReleaseDate: Option[TStamp]
    def serviceUpdateEndDate: Option[TStamp]
    def serviceUpdateSeverity
        : Option[zio.aws.elasticache.model.ServiceUpdateSeverity]
    def serviceUpdateRecommendedApplyByDate: Option[TStamp]
    def serviceUpdateStatus
        : Option[zio.aws.elasticache.model.ServiceUpdateStatus]
    def serviceUpdateDescription: Option[String]
    def serviceUpdateType: Option[zio.aws.elasticache.model.ServiceUpdateType]
    def engine: Option[String]
    def engineVersion: Option[String]
    def autoUpdateAfterRecommendedApplyByDate: Option[BooleanOptional]
    def estimatedUpdateTime: Option[String]
    def getServiceUpdateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceUpdateName", serviceUpdateName)
    def getServiceUpdateReleaseDate: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("serviceUpdateReleaseDate", serviceUpdateReleaseDate)
    def getServiceUpdateEndDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("serviceUpdateEndDate", serviceUpdateEndDate)
    def getServiceUpdateSeverity
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateSeverity] =
      AwsError.unwrapOptionField("serviceUpdateSeverity", serviceUpdateSeverity)
    def getServiceUpdateRecommendedApplyByDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "serviceUpdateRecommendedApplyByDate",
        serviceUpdateRecommendedApplyByDate
      )
    def getServiceUpdateStatus
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateStatus] =
      AwsError.unwrapOptionField("serviceUpdateStatus", serviceUpdateStatus)
    def getServiceUpdateDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("serviceUpdateDescription", serviceUpdateDescription)
    def getServiceUpdateType
        : ZIO[Any, AwsError, zio.aws.elasticache.model.ServiceUpdateType] =
      AwsError.unwrapOptionField("serviceUpdateType", serviceUpdateType)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoUpdateAfterRecommendedApplyByDate
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "autoUpdateAfterRecommendedApplyByDate",
      autoUpdateAfterRecommendedApplyByDate
    )
    def getEstimatedUpdateTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("estimatedUpdateTime", estimatedUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ServiceUpdate
  ) extends zio.aws.elasticache.model.ServiceUpdate.ReadOnly {
    override val serviceUpdateName: Option[String] =
      scala.Option(impl.serviceUpdateName()).map(value => value: String)
    override val serviceUpdateReleaseDate: Option[TStamp] = scala
      .Option(impl.serviceUpdateReleaseDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateEndDate: Option[TStamp] = scala
      .Option(impl.serviceUpdateEndDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateSeverity
        : Option[zio.aws.elasticache.model.ServiceUpdateSeverity] = scala
      .Option(impl.serviceUpdateSeverity())
      .map(value => zio.aws.elasticache.model.ServiceUpdateSeverity.wrap(value))
    override val serviceUpdateRecommendedApplyByDate: Option[TStamp] = scala
      .Option(impl.serviceUpdateRecommendedApplyByDate())
      .map(value => zio.aws.elasticache.model.primitives.TStamp(value))
    override val serviceUpdateStatus
        : Option[zio.aws.elasticache.model.ServiceUpdateStatus] = scala
      .Option(impl.serviceUpdateStatus())
      .map(value => zio.aws.elasticache.model.ServiceUpdateStatus.wrap(value))
    override val serviceUpdateDescription: Option[String] =
      scala.Option(impl.serviceUpdateDescription()).map(value => value: String)
    override val serviceUpdateType
        : Option[zio.aws.elasticache.model.ServiceUpdateType] = scala
      .Option(impl.serviceUpdateType())
      .map(value => zio.aws.elasticache.model.ServiceUpdateType.wrap(value))
    override val engine: Option[String] =
      scala.Option(impl.engine()).map(value => value: String)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoUpdateAfterRecommendedApplyByDate
        : Option[BooleanOptional] = scala
      .Option(impl.autoUpdateAfterRecommendedApplyByDate())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val estimatedUpdateTime: Option[String] =
      scala.Option(impl.estimatedUpdateTime()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ServiceUpdate
  ): zio.aws.elasticache.model.ServiceUpdate.ReadOnly = new Wrapper(impl)
}
