package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.{AllowedNodeGroupId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyReplicationGroupShardConfigurationRequest(
    replicationGroupId: String,
    nodeGroupCount: Integer,
    applyImmediately: Boolean,
    reshardingConfiguration: Option[
      Iterable[zio.aws.elasticache.model.ReshardingConfiguration]
    ] = None,
    nodeGroupsToRemove: Option[Iterable[AllowedNodeGroupId]] = None,
    nodeGroupsToRetain: Option[Iterable[AllowedNodeGroupId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest = {
    import ModifyReplicationGroupShardConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .nodeGroupCount(Integer.unwrap(nodeGroupCount): java.lang.Integer)
      .applyImmediately(applyImmediately: java.lang.Boolean)
      .optionallyWith(
        reshardingConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reshardingConfiguration)
      .optionallyWith(
        nodeGroupsToRemove.map(value =>
          value.map { item =>
            AllowedNodeGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.nodeGroupsToRemove)
      .optionallyWith(
        nodeGroupsToRetain.map(value =>
          value.map { item =>
            AllowedNodeGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.nodeGroupsToRetain)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationGroupShardConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationRequest =
      zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationRequest(
        replicationGroupId,
        nodeGroupCount,
        applyImmediately,
        reshardingConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nodeGroupsToRemove.map(value => value),
        nodeGroupsToRetain.map(value => value)
      )
    def replicationGroupId: String
    def nodeGroupCount: Integer
    def applyImmediately: Boolean
    def reshardingConfiguration: Option[
      List[zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly]
    ]
    def nodeGroupsToRemove: Option[List[AllowedNodeGroupId]]
    def nodeGroupsToRetain: Option[List[AllowedNodeGroupId]]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getNodeGroupCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(nodeGroupCount)
    def getApplyImmediately: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(applyImmediately)
    def getReshardingConfiguration: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reshardingConfiguration",
      reshardingConfiguration
    )
    def getNodeGroupsToRemove: ZIO[Any, AwsError, List[AllowedNodeGroupId]] =
      AwsError.unwrapOptionField("nodeGroupsToRemove", nodeGroupsToRemove)
    def getNodeGroupsToRetain: ZIO[Any, AwsError, List[AllowedNodeGroupId]] =
      AwsError.unwrapOptionField("nodeGroupsToRetain", nodeGroupsToRetain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest
  ) extends zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val nodeGroupCount: Integer =
      zio.aws.elasticache.model.primitives.Integer(impl.nodeGroupCount())
    override val applyImmediately: Boolean = impl.applyImmediately(): Boolean
    override val reshardingConfiguration: Option[
      List[zio.aws.elasticache.model.ReshardingConfiguration.ReadOnly]
    ] = scala
      .Option(impl.reshardingConfiguration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ReshardingConfiguration.wrap(item)
        }.toList
      )
    override val nodeGroupsToRemove: Option[List[AllowedNodeGroupId]] = scala
      .Option(impl.nodeGroupsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.AllowedNodeGroupId(item)
        }.toList
      )
    override val nodeGroupsToRetain: Option[List[AllowedNodeGroupId]] = scala
      .Option(impl.nodeGroupsToRetain())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.AllowedNodeGroupId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupShardConfigurationRequest
  ): zio.aws.elasticache.model.ModifyReplicationGroupShardConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
