package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{
  UserGroupId,
  IntegerOptional,
  BooleanOptional
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ModifyReplicationGroupRequest(
    replicationGroupId: String,
    replicationGroupDescription: Option[String] = None,
    primaryClusterId: Option[String] = None,
    snapshottingClusterId: Option[String] = None,
    automaticFailoverEnabled: Option[BooleanOptional] = None,
    multiAZEnabled: Option[BooleanOptional] = None,
    nodeGroupId: Option[String] = None,
    cacheSecurityGroupNames: Option[Iterable[String]] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    preferredMaintenanceWindow: Option[String] = None,
    notificationTopicArn: Option[String] = None,
    cacheParameterGroupName: Option[String] = None,
    notificationTopicStatus: Option[String] = None,
    applyImmediately: Option[Boolean] = None,
    engineVersion: Option[String] = None,
    autoMinorVersionUpgrade: Option[BooleanOptional] = None,
    snapshotRetentionLimit: Option[IntegerOptional] = None,
    snapshotWindow: Option[String] = None,
    cacheNodeType: Option[String] = None,
    authToken: Option[String] = None,
    authTokenUpdateStrategy: Option[
      zio.aws.elasticache.model.AuthTokenUpdateStrategyType
    ] = None,
    userGroupIdsToAdd: Option[Iterable[UserGroupId]] = None,
    userGroupIdsToRemove: Option[Iterable[UserGroupId]] = None,
    removeUserGroups: Option[BooleanOptional] = None,
    logDeliveryConfigurations: Option[
      Iterable[zio.aws.elasticache.model.LogDeliveryConfigurationRequest]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest = {
    import ModifyReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .optionallyWith(
        replicationGroupDescription.map(value => value: java.lang.String)
      )(_.replicationGroupDescription)
      .optionallyWith(primaryClusterId.map(value => value: java.lang.String))(
        _.primaryClusterId
      )
      .optionallyWith(
        snapshottingClusterId.map(value => value: java.lang.String)
      )(_.snapshottingClusterId)
      .optionallyWith(
        automaticFailoverEnabled.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.automaticFailoverEnabled)
      .optionallyWith(
        multiAZEnabled.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.multiAZEnabled)
      .optionallyWith(nodeGroupId.map(value => value: java.lang.String))(
        _.nodeGroupId
      )
      .optionallyWith(
        cacheSecurityGroupNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cacheSecurityGroupNames)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        notificationTopicArn.map(value => value: java.lang.String)
      )(_.notificationTopicArn)
      .optionallyWith(
        cacheParameterGroupName.map(value => value: java.lang.String)
      )(_.cacheParameterGroupName)
      .optionallyWith(
        notificationTopicStatus.map(value => value: java.lang.String)
      )(_.notificationTopicStatus)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        snapshotRetentionLimit.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.snapshotRetentionLimit)
      .optionallyWith(snapshotWindow.map(value => value: java.lang.String))(
        _.snapshotWindow
      )
      .optionallyWith(cacheNodeType.map(value => value: java.lang.String))(
        _.cacheNodeType
      )
      .optionallyWith(authToken.map(value => value: java.lang.String))(
        _.authToken
      )
      .optionallyWith(authTokenUpdateStrategy.map(value => value.unwrap))(
        _.authTokenUpdateStrategy
      )
      .optionallyWith(
        userGroupIdsToAdd.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIdsToAdd)
      .optionallyWith(
        userGroupIdsToRemove.map(value =>
          value.map { item =>
            UserGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userGroupIdsToRemove)
      .optionallyWith(
        removeUserGroups.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.removeUserGroups)
      .optionallyWith(
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logDeliveryConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.ModifyReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.ModifyReplicationGroupRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.ModifyReplicationGroupRequest =
      zio.aws.elasticache.model.ModifyReplicationGroupRequest(
        replicationGroupId,
        replicationGroupDescription.map(value => value),
        primaryClusterId.map(value => value),
        snapshottingClusterId.map(value => value),
        automaticFailoverEnabled.map(value => value),
        multiAZEnabled.map(value => value),
        nodeGroupId.map(value => value),
        cacheSecurityGroupNames.map(value => value),
        securityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        notificationTopicArn.map(value => value),
        cacheParameterGroupName.map(value => value),
        notificationTopicStatus.map(value => value),
        applyImmediately.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        snapshotRetentionLimit.map(value => value),
        snapshotWindow.map(value => value),
        cacheNodeType.map(value => value),
        authToken.map(value => value),
        authTokenUpdateStrategy.map(value => value),
        userGroupIdsToAdd.map(value => value),
        userGroupIdsToRemove.map(value => value),
        removeUserGroups.map(value => value),
        logDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationGroupId: String
    def replicationGroupDescription: Option[String]
    def primaryClusterId: Option[String]
    def snapshottingClusterId: Option[String]
    def automaticFailoverEnabled: Option[BooleanOptional]
    def multiAZEnabled: Option[BooleanOptional]
    def nodeGroupId: Option[String]
    def cacheSecurityGroupNames: Option[List[String]]
    def securityGroupIds: Option[List[String]]
    def preferredMaintenanceWindow: Option[String]
    def notificationTopicArn: Option[String]
    def cacheParameterGroupName: Option[String]
    def notificationTopicStatus: Option[String]
    def applyImmediately: Option[Boolean]
    def engineVersion: Option[String]
    def autoMinorVersionUpgrade: Option[BooleanOptional]
    def snapshotRetentionLimit: Option[IntegerOptional]
    def snapshotWindow: Option[String]
    def cacheNodeType: Option[String]
    def authToken: Option[String]
    def authTokenUpdateStrategy
        : Option[zio.aws.elasticache.model.AuthTokenUpdateStrategyType]
    def userGroupIdsToAdd: Option[List[UserGroupId]]
    def userGroupIdsToRemove: Option[List[UserGroupId]]
    def removeUserGroups: Option[BooleanOptional]
    def logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ]
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getReplicationGroupDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationGroupDescription",
        replicationGroupDescription
      )
    def getPrimaryClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("primaryClusterId", primaryClusterId)
    def getSnapshottingClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshottingClusterId", snapshottingClusterId)
    def getAutomaticFailoverEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "automaticFailoverEnabled",
        automaticFailoverEnabled
      )
    def getMultiAZEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZEnabled", multiAZEnabled)
    def getNodeGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeGroupId", nodeGroupId)
    def getCacheSecurityGroupNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("cacheSecurityGroupNames", cacheSecurityGroupNames)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getNotificationTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("notificationTopicArn", notificationTopicArn)
    def getCacheParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("cacheParameterGroupName", cacheParameterGroupName)
    def getNotificationTopicStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("notificationTopicStatus", notificationTopicStatus)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getSnapshotRetentionLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "snapshotRetentionLimit",
        snapshotRetentionLimit
      )
    def getSnapshotWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotWindow", snapshotWindow)
    def getCacheNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheNodeType", cacheNodeType)
    def getAuthToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authToken", authToken)
    def getAuthTokenUpdateStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AuthTokenUpdateStrategyType
    ] = AwsError.unwrapOptionField(
      "authTokenUpdateStrategy",
      authTokenUpdateStrategy
    )
    def getUserGroupIdsToAdd: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIdsToAdd", userGroupIdsToAdd)
    def getUserGroupIdsToRemove: ZIO[Any, AwsError, List[UserGroupId]] =
      AwsError.unwrapOptionField("userGroupIdsToRemove", userGroupIdsToRemove)
    def getRemoveUserGroups: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("removeUserGroups", removeUserGroups)
    def getLogDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "logDeliveryConfigurations",
      logDeliveryConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest
  ) extends zio.aws.elasticache.model.ModifyReplicationGroupRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val replicationGroupDescription: Option[String] = scala
      .Option(impl.replicationGroupDescription())
      .map(value => value: String)
    override val primaryClusterId: Option[String] =
      scala.Option(impl.primaryClusterId()).map(value => value: String)
    override val snapshottingClusterId: Option[String] =
      scala.Option(impl.snapshottingClusterId()).map(value => value: String)
    override val automaticFailoverEnabled: Option[BooleanOptional] = scala
      .Option(impl.automaticFailoverEnabled())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val multiAZEnabled: Option[BooleanOptional] = scala
      .Option(impl.multiAZEnabled())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val nodeGroupId: Option[String] =
      scala.Option(impl.nodeGroupId()).map(value => value: String)
    override val cacheSecurityGroupNames: Option[List[String]] = scala
      .Option(impl.cacheSecurityGroupNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val notificationTopicArn: Option[String] =
      scala.Option(impl.notificationTopicArn()).map(value => value: String)
    override val cacheParameterGroupName: Option[String] =
      scala.Option(impl.cacheParameterGroupName()).map(value => value: String)
    override val notificationTopicStatus: Option[String] =
      scala.Option(impl.notificationTopicStatus()).map(value => value: String)
    override val applyImmediately: Option[Boolean] =
      scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override val engineVersion: Option[String] =
      scala.Option(impl.engineVersion()).map(value => value: String)
    override val autoMinorVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.autoMinorVersionUpgrade())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val snapshotRetentionLimit: Option[IntegerOptional] = scala
      .Option(impl.snapshotRetentionLimit())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val snapshotWindow: Option[String] =
      scala.Option(impl.snapshotWindow()).map(value => value: String)
    override val cacheNodeType: Option[String] =
      scala.Option(impl.cacheNodeType()).map(value => value: String)
    override val authToken: Option[String] =
      scala.Option(impl.authToken()).map(value => value: String)
    override val authTokenUpdateStrategy
        : Option[zio.aws.elasticache.model.AuthTokenUpdateStrategyType] = scala
      .Option(impl.authTokenUpdateStrategy())
      .map(value =>
        zio.aws.elasticache.model.AuthTokenUpdateStrategyType.wrap(value)
      )
    override val userGroupIdsToAdd: Option[List[UserGroupId]] = scala
      .Option(impl.userGroupIdsToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserGroupId(item)
        }.toList
      )
    override val userGroupIdsToRemove: Option[List[UserGroupId]] = scala
      .Option(impl.userGroupIdsToRemove())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.primitives.UserGroupId(item)
        }.toList
      )
    override val removeUserGroups: Option[BooleanOptional] = scala
      .Option(impl.removeUserGroups())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val logDeliveryConfigurations: Option[
      List[zio.aws.elasticache.model.LogDeliveryConfigurationRequest.ReadOnly]
    ] = scala
      .Option(impl.logDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.LogDeliveryConfigurationRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.ModifyReplicationGroupRequest
  ): zio.aws.elasticache.model.ModifyReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
