package zio.aws.elasticache.model
import zio.aws.elasticache.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IncreaseNodeGroupsInGlobalReplicationGroupRequest(
    globalReplicationGroupId: String,
    nodeGroupCount: Integer,
    regionalConfigurations: Option[
      Iterable[zio.aws.elasticache.model.RegionalConfiguration]
    ] = None,
    applyImmediately: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest = {
    import IncreaseNodeGroupsInGlobalReplicationGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest
      .builder()
      .globalReplicationGroupId(globalReplicationGroupId: java.lang.String)
      .nodeGroupCount(Integer.unwrap(nodeGroupCount): java.lang.Integer)
      .optionallyWith(
        regionalConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regionalConfigurations)
      .applyImmediately(applyImmediately: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest.ReadOnly =
    zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest
      .wrap(buildAwsValue())
}
object IncreaseNodeGroupsInGlobalReplicationGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest =
      zio.aws.elasticache.model
        .IncreaseNodeGroupsInGlobalReplicationGroupRequest(
          globalReplicationGroupId,
          nodeGroupCount,
          regionalConfigurations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          applyImmediately
        )
    def globalReplicationGroupId: String
    def nodeGroupCount: Integer
    def regionalConfigurations
        : Option[List[zio.aws.elasticache.model.RegionalConfiguration.ReadOnly]]
    def applyImmediately: Boolean
    def getGlobalReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(globalReplicationGroupId)
    def getNodeGroupCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(nodeGroupCount)
    def getRegionalConfigurations: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.RegionalConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "regionalConfigurations",
      regionalConfigurations
    )
    def getApplyImmediately: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(applyImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest
  ) extends zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest.ReadOnly {
    override val globalReplicationGroupId: String =
      impl.globalReplicationGroupId(): String
    override val nodeGroupCount: Integer =
      zio.aws.elasticache.model.primitives.Integer(impl.nodeGroupCount())
    override val regionalConfigurations: Option[
      List[zio.aws.elasticache.model.RegionalConfiguration.ReadOnly]
    ] = scala
      .Option(impl.regionalConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.RegionalConfiguration.wrap(item)
        }.toList
      )
    override val applyImmediately: Boolean = impl.applyImmediately(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest
  ): zio.aws.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupRequest.ReadOnly =
    new Wrapper(impl)
}
