package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GlobalReplicationGroupMember(
    replicationGroupId: Option[String] = None,
    replicationGroupRegion: Option[String] = None,
    role: Option[String] = None,
    automaticFailover: Option[
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember = {
    import GlobalReplicationGroupMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(
        replicationGroupRegion.map(value => value: java.lang.String)
      )(_.replicationGroupRegion)
      .optionallyWith(role.map(value => value: java.lang.String))(_.role)
      .optionallyWith(automaticFailover.map(value => value.unwrap))(
        _.automaticFailover
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly =
    zio.aws.elasticache.model.GlobalReplicationGroupMember.wrap(buildAwsValue())
}
object GlobalReplicationGroupMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.GlobalReplicationGroupMember =
      zio.aws.elasticache.model.GlobalReplicationGroupMember(
        replicationGroupId.map(value => value),
        replicationGroupRegion.map(value => value),
        role.map(value => value),
        automaticFailover.map(value => value),
        status.map(value => value)
      )
    def replicationGroupId: Option[String]
    def replicationGroupRegion: Option[String]
    def role: Option[String]
    def automaticFailover
        : Option[zio.aws.elasticache.model.AutomaticFailoverStatus]
    def status: Option[String]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getReplicationGroupRegion: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationGroupRegion", replicationGroupRegion)
    def getRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("role", role)
    def getAutomaticFailover: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.AutomaticFailoverStatus
    ] = AwsError.unwrapOptionField("automaticFailover", automaticFailover)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember
  ) extends zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly {
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
    override val replicationGroupRegion: Option[String] =
      scala.Option(impl.replicationGroupRegion()).map(value => value: String)
    override val role: Option[String] =
      scala.Option(impl.role()).map(value => value: String)
    override val automaticFailover
        : Option[zio.aws.elasticache.model.AutomaticFailoverStatus] = scala
      .Option(impl.automaticFailover())
      .map(value =>
        zio.aws.elasticache.model.AutomaticFailoverStatus.wrap(value)
      )
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroupMember
  ): zio.aws.elasticache.model.GlobalReplicationGroupMember.ReadOnly =
    new Wrapper(impl)
}
