package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GlobalNodeGroup(
    globalNodeGroupId: Option[String] = None,
    slots: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup = {
    import GlobalNodeGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup
      .builder()
      .optionallyWith(globalNodeGroupId.map(value => value: java.lang.String))(
        _.globalNodeGroupId
      )
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly =
    zio.aws.elasticache.model.GlobalNodeGroup.wrap(buildAwsValue())
}
object GlobalNodeGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.GlobalNodeGroup =
      zio.aws.elasticache.model.GlobalNodeGroup(
        globalNodeGroupId.map(value => value),
        slots.map(value => value)
      )
    def globalNodeGroupId: Option[String]
    def slots: Option[String]
    def getGlobalNodeGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("globalNodeGroupId", globalNodeGroupId)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup
  ) extends zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly {
    override val globalNodeGroupId: Option[String] =
      scala.Option(impl.globalNodeGroupId()).map(value => value: String)
    override val slots: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.GlobalNodeGroup
  ): zio.aws.elasticache.model.GlobalNodeGroup.ReadOnly = new Wrapper(impl)
}
