package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeUserGroupsRequest(
    userGroupId: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest = {
    import DescribeUserGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest
      .builder()
      .optionallyWith(userGroupId.map(value => value: java.lang.String))(
        _.userGroupId
      )
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.DescribeUserGroupsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeUserGroupsRequest.wrap(buildAwsValue())
}
object DescribeUserGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeUserGroupsRequest =
      zio.aws.elasticache.model.DescribeUserGroupsRequest(
        userGroupId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def userGroupId: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getUserGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userGroupId", userGroupId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest
  ) extends zio.aws.elasticache.model.DescribeUserGroupsRequest.ReadOnly {
    override val userGroupId: Option[String] =
      scala.Option(impl.userGroupId()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest
  ): zio.aws.elasticache.model.DescribeUserGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
