package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeReservedCacheNodesOfferingsResponse(
    marker: Option[String] = None,
    reservedCacheNodesOfferings: Option[
      Iterable[zio.aws.elasticache.model.ReservedCacheNodesOffering]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse = {
    import DescribeReservedCacheNodesOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedCacheNodesOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedCacheNodesOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedCacheNodesOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse =
      zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse(
        marker.map(value => value),
        reservedCacheNodesOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def reservedCacheNodesOfferings: Option[
      List[zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedCacheNodesOfferings: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedCacheNodesOfferings",
      reservedCacheNodesOfferings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
  ) extends zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val reservedCacheNodesOfferings: Option[
      List[zio.aws.elasticache.model.ReservedCacheNodesOffering.ReadOnly]
    ] = scala
      .Option(impl.reservedCacheNodesOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.ReservedCacheNodesOffering.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReservedCacheNodesOfferingsResponse
  ): zio.aws.elasticache.model.DescribeReservedCacheNodesOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
