package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeReplicationGroupsRequest(
    replicationGroupId: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest = {
    import DescribeReplicationGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest
      .builder()
      .optionallyWith(replicationGroupId.map(value => value: java.lang.String))(
        _.replicationGroupId
      )
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeReplicationGroupsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeReplicationGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeReplicationGroupsRequest =
      zio.aws.elasticache.model.DescribeReplicationGroupsRequest(
        replicationGroupId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def replicationGroupId: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getReplicationGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationGroupId", replicationGroupId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest
  ) extends zio.aws.elasticache.model.DescribeReplicationGroupsRequest.ReadOnly {
    override val replicationGroupId: Option[String] =
      scala.Option(impl.replicationGroupId()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest
  ): zio.aws.elasticache.model.DescribeReplicationGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
