package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeEngineDefaultParametersResponse(
    engineDefaults: Option[zio.aws.elasticache.model.EngineDefaults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse = {
    import DescribeEngineDefaultParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse
      .builder()
      .optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(
        _.engineDefaults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse
      .wrap(buildAwsValue())
}
object DescribeEngineDefaultParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse =
      zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse(
        engineDefaults.map(value => value.asEditable)
      )
    def engineDefaults
        : Option[zio.aws.elasticache.model.EngineDefaults.ReadOnly]
    def getEngineDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.EngineDefaults.ReadOnly
    ] = AwsError.unwrapOptionField("engineDefaults", engineDefaults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse
  ) extends zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.ReadOnly {
    override val engineDefaults
        : Option[zio.aws.elasticache.model.EngineDefaults.ReadOnly] = scala
      .Option(impl.engineDefaults())
      .map(value => zio.aws.elasticache.model.EngineDefaults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse
  ): zio.aws.elasticache.model.DescribeEngineDefaultParametersResponse.ReadOnly =
    new Wrapper(impl)
}
