package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCacheSubnetGroupsResponse(
    marker: Option[String] = None,
    cacheSubnetGroups: Option[
      Iterable[zio.aws.elasticache.model.CacheSubnetGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse = {
    import DescribeCacheSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        cacheSubnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheSubnetGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeCacheSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse =
      zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse(
        marker.map(value => value),
        cacheSubnetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def cacheSubnetGroups
        : Option[List[zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCacheSubnetGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheSubnetGroups", cacheSubnetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse
  ) extends zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val cacheSubnetGroups
        : Option[List[zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly]] =
      scala
        .Option(impl.cacheSubnetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.CacheSubnetGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsResponse
  ): zio.aws.elasticache.model.DescribeCacheSubnetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
