package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCacheSubnetGroupsRequest(
    cacheSubnetGroupName: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest = {
    import DescribeCacheSubnetGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest
      .builder()
      .optionallyWith(
        cacheSubnetGroupName.map(value => value: java.lang.String)
      )(_.cacheSubnetGroupName)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheSubnetGroupsRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheSubnetGroupsRequest
      .wrap(buildAwsValue())
}
object DescribeCacheSubnetGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeCacheSubnetGroupsRequest =
      zio.aws.elasticache.model.DescribeCacheSubnetGroupsRequest(
        cacheSubnetGroupName.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def cacheSubnetGroupName: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getCacheSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheSubnetGroupName", cacheSubnetGroupName)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest
  ) extends zio.aws.elasticache.model.DescribeCacheSubnetGroupsRequest.ReadOnly {
    override val cacheSubnetGroupName: Option[String] =
      scala.Option(impl.cacheSubnetGroupName()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSubnetGroupsRequest
  ): zio.aws.elasticache.model.DescribeCacheSubnetGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
