package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCacheSecurityGroupsResponse(
    marker: Option[String] = None,
    cacheSecurityGroups: Option[
      Iterable[zio.aws.elasticache.model.CacheSecurityGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse = {
    import DescribeCacheSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        cacheSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheSecurityGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeCacheSecurityGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse =
      zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse(
        marker.map(value => value),
        cacheSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def cacheSecurityGroups
        : Option[List[zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getCacheSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheSecurityGroups", cacheSecurityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse
  ) extends zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val cacheSecurityGroups
        : Option[List[zio.aws.elasticache.model.CacheSecurityGroup.ReadOnly]] =
      scala
        .Option(impl.cacheSecurityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.CacheSecurityGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheSecurityGroupsResponse
  ): zio.aws.elasticache.model.DescribeCacheSecurityGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
