package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCacheParametersResponse(
    marker: Option[String] = None,
    parameters: Option[Iterable[zio.aws.elasticache.model.Parameter]] = None,
    cacheNodeTypeSpecificParameters: Option[
      Iterable[zio.aws.elasticache.model.CacheNodeTypeSpecificParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse = {
    import DescribeCacheParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        cacheNodeTypeSpecificParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheNodeTypeSpecificParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheParametersResponse.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheParametersResponse
      .wrap(buildAwsValue())
}
object DescribeCacheParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeCacheParametersResponse =
      zio.aws.elasticache.model.DescribeCacheParametersResponse(
        marker.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cacheNodeTypeSpecificParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def parameters: Option[List[zio.aws.elasticache.model.Parameter.ReadOnly]]
    def cacheNodeTypeSpecificParameters: Option[
      List[zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCacheNodeTypeSpecificParameters: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cacheNodeTypeSpecificParameters",
      cacheNodeTypeSpecificParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse
  ) extends zio.aws.elasticache.model.DescribeCacheParametersResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val parameters
        : Option[List[zio.aws.elasticache.model.Parameter.ReadOnly]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.Parameter.wrap(item)
        }.toList
      )
    override val cacheNodeTypeSpecificParameters: Option[
      List[zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.ReadOnly]
    ] = scala
      .Option(impl.cacheNodeTypeSpecificParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticache.model.CacheNodeTypeSpecificParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse
  ): zio.aws.elasticache.model.DescribeCacheParametersResponse.ReadOnly =
    new Wrapper(impl)
}
