package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeCacheClustersRequest(
    cacheClusterId: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    showCacheNodeInfo: Option[BooleanOptional] = None,
    showCacheClustersNotInReplicationGroups: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest = {
    import DescribeCacheClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest
      .builder()
      .optionallyWith(cacheClusterId.map(value => value: java.lang.String))(
        _.cacheClusterId
      )
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        showCacheNodeInfo.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.showCacheNodeInfo)
      .optionallyWith(
        showCacheClustersNotInReplicationGroups.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.showCacheClustersNotInReplicationGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DescribeCacheClustersRequest.ReadOnly =
    zio.aws.elasticache.model.DescribeCacheClustersRequest.wrap(buildAwsValue())
}
object DescribeCacheClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DescribeCacheClustersRequest =
      zio.aws.elasticache.model.DescribeCacheClustersRequest(
        cacheClusterId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        showCacheNodeInfo.map(value => value),
        showCacheClustersNotInReplicationGroups.map(value => value)
      )
    def cacheClusterId: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def showCacheNodeInfo: Option[BooleanOptional]
    def showCacheClustersNotInReplicationGroups: Option[BooleanOptional]
    def getCacheClusterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheClusterId", cacheClusterId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getShowCacheNodeInfo: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("showCacheNodeInfo", showCacheNodeInfo)
    def getShowCacheClustersNotInReplicationGroups
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "showCacheClustersNotInReplicationGroups",
      showCacheClustersNotInReplicationGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest
  ) extends zio.aws.elasticache.model.DescribeCacheClustersRequest.ReadOnly {
    override val cacheClusterId: Option[String] =
      scala.Option(impl.cacheClusterId()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val showCacheNodeInfo: Option[BooleanOptional] = scala
      .Option(impl.showCacheNodeInfo())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
    override val showCacheClustersNotInReplicationGroups
        : Option[BooleanOptional] = scala
      .Option(impl.showCacheClustersNotInReplicationGroups())
      .map(value => zio.aws.elasticache.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DescribeCacheClustersRequest
  ): zio.aws.elasticache.model.DescribeCacheClustersRequest.ReadOnly =
    new Wrapper(impl)
}
