package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteGlobalReplicationGroupResponse(
    globalReplicationGroup: Option[
      zio.aws.elasticache.model.GlobalReplicationGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupResponse = {
    import DeleteGlobalReplicationGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupResponse
      .builder()
      .optionallyWith(
        globalReplicationGroup.map(value => value.buildAwsValue())
      )(_.globalReplicationGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.ReadOnly =
    zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse
      .wrap(buildAwsValue())
}
object DeleteGlobalReplicationGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse =
      zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse(
        globalReplicationGroup.map(value => value.asEditable)
      )
    def globalReplicationGroup
        : Option[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly]
    def getGlobalReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalReplicationGroup",
      globalReplicationGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupResponse
  ) extends zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.ReadOnly {
    override val globalReplicationGroup
        : Option[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly] =
      scala
        .Option(impl.globalReplicationGroup())
        .map(value =>
          zio.aws.elasticache.model.GlobalReplicationGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DeleteGlobalReplicationGroupResponse
  ): zio.aws.elasticache.model.DeleteGlobalReplicationGroupResponse.ReadOnly =
    new Wrapper(impl)
}
