package zio.aws.elasticache.model
import java.lang.Integer
import zio.aws.elasticache.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DecreaseReplicaCountRequest(
    replicationGroupId: String,
    newReplicaCount: Option[IntegerOptional] = None,
    replicaConfiguration: Option[
      Iterable[zio.aws.elasticache.model.ConfigureShard]
    ] = None,
    replicasToRemove: Option[Iterable[String]] = None,
    applyImmediately: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest = {
    import DecreaseReplicaCountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest
      .builder()
      .replicationGroupId(replicationGroupId: java.lang.String)
      .optionallyWith(
        newReplicaCount.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.newReplicaCount)
      .optionallyWith(
        replicaConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicaConfiguration)
      .optionallyWith(
        replicasToRemove.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicasToRemove)
      .applyImmediately(applyImmediately: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DecreaseReplicaCountRequest.ReadOnly =
    zio.aws.elasticache.model.DecreaseReplicaCountRequest.wrap(buildAwsValue())
}
object DecreaseReplicaCountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.DecreaseReplicaCountRequest =
      zio.aws.elasticache.model.DecreaseReplicaCountRequest(
        replicationGroupId,
        newReplicaCount.map(value => value),
        replicaConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        replicasToRemove.map(value => value),
        applyImmediately
      )
    def replicationGroupId: String
    def newReplicaCount: Option[IntegerOptional]
    def replicaConfiguration
        : Option[List[zio.aws.elasticache.model.ConfigureShard.ReadOnly]]
    def replicasToRemove: Option[List[String]]
    def applyImmediately: Boolean
    def getReplicationGroupId: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationGroupId)
    def getNewReplicaCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("newReplicaCount", newReplicaCount)
    def getReplicaConfiguration: ZIO[Any, AwsError, List[
      zio.aws.elasticache.model.ConfigureShard.ReadOnly
    ]] =
      AwsError.unwrapOptionField("replicaConfiguration", replicaConfiguration)
    def getReplicasToRemove: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("replicasToRemove", replicasToRemove)
    def getApplyImmediately: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(applyImmediately)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest
  ) extends zio.aws.elasticache.model.DecreaseReplicaCountRequest.ReadOnly {
    override val replicationGroupId: String = impl.replicationGroupId(): String
    override val newReplicaCount: Option[IntegerOptional] = scala
      .Option(impl.newReplicaCount())
      .map(value => zio.aws.elasticache.model.primitives.IntegerOptional(value))
    override val replicaConfiguration
        : Option[List[zio.aws.elasticache.model.ConfigureShard.ReadOnly]] =
      scala
        .Option(impl.replicaConfiguration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticache.model.ConfigureShard.wrap(item)
          }.toList
        )
    override val replicasToRemove: Option[List[String]] = scala
      .Option(impl.replicasToRemove())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val applyImmediately: Boolean = impl.applyImmediately(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseReplicaCountRequest
  ): zio.aws.elasticache.model.DecreaseReplicaCountRequest.ReadOnly =
    new Wrapper(impl)
}
