package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DecreaseNodeGroupsInGlobalReplicationGroupResponse(
    globalReplicationGroup: Option[
      zio.aws.elasticache.model.GlobalReplicationGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse = {
    import DecreaseNodeGroupsInGlobalReplicationGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse
      .builder()
      .optionallyWith(
        globalReplicationGroup.map(value => value.buildAwsValue())
      )(_.globalReplicationGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly =
    zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse
      .wrap(buildAwsValue())
}
object DecreaseNodeGroupsInGlobalReplicationGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse =
      zio.aws.elasticache.model
        .DecreaseNodeGroupsInGlobalReplicationGroupResponse(
          globalReplicationGroup.map(value => value.asEditable)
        )
    def globalReplicationGroup
        : Option[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly]
    def getGlobalReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "globalReplicationGroup",
      globalReplicationGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse
  ) extends zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly {
    override val globalReplicationGroup
        : Option[zio.aws.elasticache.model.GlobalReplicationGroup.ReadOnly] =
      scala
        .Option(impl.globalReplicationGroup())
        .map(value =>
          zio.aws.elasticache.model.GlobalReplicationGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse
  ): zio.aws.elasticache.model.DecreaseNodeGroupsInGlobalReplicationGroupResponse.ReadOnly =
    new Wrapper(impl)
}
