package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateCacheSubnetGroupResponse(
    cacheSubnetGroup: Option[zio.aws.elasticache.model.CacheSubnetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse = {
    import CreateCacheSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse
      .builder()
      .optionallyWith(cacheSubnetGroup.map(value => value.buildAwsValue()))(
        _.cacheSubnetGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.ReadOnly =
    zio.aws.elasticache.model.CreateCacheSubnetGroupResponse
      .wrap(buildAwsValue())
}
object CreateCacheSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CreateCacheSubnetGroupResponse =
      zio.aws.elasticache.model.CreateCacheSubnetGroupResponse(
        cacheSubnetGroup.map(value => value.asEditable)
      )
    def cacheSubnetGroup
        : Option[zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly]
    def getCacheSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("cacheSubnetGroup", cacheSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse
  ) extends zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.ReadOnly {
    override val cacheSubnetGroup
        : Option[zio.aws.elasticache.model.CacheSubnetGroup.ReadOnly] = scala
      .Option(impl.cacheSubnetGroup())
      .map(value => zio.aws.elasticache.model.CacheSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CreateCacheSubnetGroupResponse
  ): zio.aws.elasticache.model.CreateCacheSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
