package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopySnapshotResponse(
    snapshot: Option[zio.aws.elasticache.model.Snapshot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse = {
    import CopySnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CopySnapshotResponse.ReadOnly =
    zio.aws.elasticache.model.CopySnapshotResponse.wrap(buildAwsValue())
}
object CopySnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CopySnapshotResponse =
      zio.aws.elasticache.model
        .CopySnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Option[zio.aws.elasticache.model.Snapshot.ReadOnly]
    def getSnapshot
        : ZIO[Any, AwsError, zio.aws.elasticache.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse
  ) extends zio.aws.elasticache.model.CopySnapshotResponse.ReadOnly {
    override val snapshot: Option[zio.aws.elasticache.model.Snapshot.ReadOnly] =
      scala
        .Option(impl.snapshot())
        .map(value => zio.aws.elasticache.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CopySnapshotResponse
  ): zio.aws.elasticache.model.CopySnapshotResponse.ReadOnly = new Wrapper(impl)
}
