package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CompleteMigrationResponse(
    replicationGroup: Option[zio.aws.elasticache.model.ReplicationGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CompleteMigrationResponse = {
    import CompleteMigrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CompleteMigrationResponse
      .builder()
      .optionallyWith(replicationGroup.map(value => value.buildAwsValue()))(
        _.replicationGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticache.model.CompleteMigrationResponse.ReadOnly =
    zio.aws.elasticache.model.CompleteMigrationResponse.wrap(buildAwsValue())
}
object CompleteMigrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CompleteMigrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CompleteMigrationResponse =
      zio.aws.elasticache.model.CompleteMigrationResponse(
        replicationGroup.map(value => value.asEditable)
      )
    def replicationGroup
        : Option[zio.aws.elasticache.model.ReplicationGroup.ReadOnly]
    def getReplicationGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticache.model.ReplicationGroup.ReadOnly
    ] = AwsError.unwrapOptionField("replicationGroup", replicationGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CompleteMigrationResponse
  ) extends zio.aws.elasticache.model.CompleteMigrationResponse.ReadOnly {
    override val replicationGroup
        : Option[zio.aws.elasticache.model.ReplicationGroup.ReadOnly] = scala
      .Option(impl.replicationGroup())
      .map(value => zio.aws.elasticache.model.ReplicationGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CompleteMigrationResponse
  ): zio.aws.elasticache.model.CompleteMigrationResponse.ReadOnly = new Wrapper(
    impl
  )
}
