package zio.aws.elasticache.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsDestinationDetails(
    logGroup: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticache.model.CloudWatchLogsDestinationDetails = {
    import CloudWatchLogsDestinationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticache.model.CloudWatchLogsDestinationDetails
      .builder()
      .optionallyWith(logGroup.map(value => value: java.lang.String))(
        _.logGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticache.model.CloudWatchLogsDestinationDetails.ReadOnly =
    zio.aws.elasticache.model.CloudWatchLogsDestinationDetails
      .wrap(buildAwsValue())
}
object CloudWatchLogsDestinationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticache.model.CloudWatchLogsDestinationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticache.model.CloudWatchLogsDestinationDetails =
      zio.aws.elasticache.model
        .CloudWatchLogsDestinationDetails(logGroup.map(value => value))
    def logGroup: Option[String]
    def getLogGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticache.model.CloudWatchLogsDestinationDetails
  ) extends zio.aws.elasticache.model.CloudWatchLogsDestinationDetails.ReadOnly {
    override val logGroup: Option[String] =
      scala.Option(impl.logGroup()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticache.model.CloudWatchLogsDestinationDetails
  ): zio.aws.elasticache.model.CloudWatchLogsDestinationDetails.ReadOnly =
    new Wrapper(impl)
}
